# Video_Ort

## 目录
- [目录结构](#目录结构)
- [项目介绍](#项目介绍)
- [环境配置](#环境配置)
- [编译运行](#编译运行)
- [参考文档](#参考文档)
- [历史版本](#历史版本)

## 目录结构
```
├── CMakeLists.txt
├── include
├── lib
│   ├── libdecode.so
│   └── libQueue.so
├── README.md
├── Resource
│   ├── Images
│   └── Models
└── src
    ├── CommonUtils.cpp
    ├── DetectorYOLOV3.cpp
    ├── DetectorYOLOV5.cpp
    ├── DetectorYOLOV7.cpp
    ├── main.cpp
    ├── yolov3-tiny.cpp
    ├── yolov5s.cpp
    └── yolov7-tiny.cpp
```

## 项目介绍

基于CPU解码，onnxruntime框架推理的视频推理范例

## 环境配置

推荐使用docker方式运行，提供[光源](https://www.sourcefind.cn/#/service-list)拉取的docker镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm0.10_ort1.14.0_migraphx3.0.0-dtk23.04
```

## 编译运行

### 编译
```
git clone https://developer.hpccube.com/codes/modelzoo/video_ort.git
cd video_ort
mkdir build
cd build
cmake ../
make
```

### 运行
```
./Video_Ort
```
根据提示选择要运行的示例程序，比如执行:
```
./Video_Ort 0
```
运行CPU解码并运行YOLOV3推理示例程序


## 参考文档

文档参考Doc目录下说明文档.

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/video_ort.git

