/* 
 * queue for Decoder and Detector
 * 2023.03.04 sugon
 * */

#ifndef __QUEUE_H__
#define __QUEUE_H__


#include <pthread.h>
#include <queue>
#include <condition_variable>
#include <mutex>
#include <sys/time.h>
#include <opencv2/opencv.hpp>
#include <SimpleLog.h>
#include <Decoder.h>

using std::queue;

namespace migraphxSamples
{

#define CAPACITY 1

class Queue
{
public:
    Queue(size_t Capacity = CAPACITY);
    ~Queue();
  
    void enQueue(cv::Mat& Image);
    void enQueue(DCU_Frame& dcu_frame);
  
    void deQueue(cv::Mat* Image);
    void deQueue(DCU_Frame* dcu_frame);

    void finish();

    bool CQ_Isempty();
    bool DQ_Isempty();

    bool DecodeEnd;

    int device;

private:
    bool CQ_IsFull();
    bool DQ_IsFull();

    queue<cv::Mat> C_Queue;
    queue<DCU_Frame> D_Queue;
    size_t _Capacity;
    pthread_mutex_t Lock;
    pthread_cond_t ConsumeCond;
    pthread_cond_t ProductCond;
};

}

#endif
