# YoloV7
## 论文
`YOLOv7: Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors`
- https://arxiv.org/pdf/2207.02696.pdf

## 模型结构
YOLOV7是2022年最新出现的一种YOLO系列目标检测模型，该模型的网络结构包括三个部分：input、backbone和head。

<img src="./Doc/YoloV7_model.png" alt="YOLOV7_02" style="zoom:67%;" />

## 算法原理
YOLOv7的作者提出了 Extended-ELAN (E-ELAN)结构。E-ELAN采用了ELAN类似的特征聚合和特征转移流程，仅在计算模块中采用了类似ShuffleNet的分组卷积、扩张模块和混洗模块，最终通过聚合模块融合特征。通过采
用这种方法可以获得更加多样的特征，同时提高参数的计算和利用效率。

<img src="./Doc/YoloV7_suanfa.png" alt="YOLOV7_suanfa" style="zoom:67%;" />

## 环境配置
### Docker（方法一）
拉取镜像：
```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:decode-ffmpeg-dtk23.04
```

创建并启动容器：
```plaintext
docker run --shm-size 16g --network=host --name=video_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/video_migraphx:/home/video_migraphx -it <Your Image ID> /bin/bash
```

### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t video_migraphx:test .

docker run --shm-size 16g --network=host --name=video_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/video_migraphx:/home/video_migraphx -it <Your Image ID> /bin/bash
```

## 数据集
根据提供的视频文件，进行目标检测。

## 推理
### 编译工程
```
git clone https://developer.hpccube.com/codes/modelzoo/video_migraphx.git
cd video_migraphx
mkdir build
cd build
使用CPU解码和解码卡软件帧：
cmake ../ -DUSE_P2P=0
使用解码卡硬件帧：
cmake ../ -DUSE_P2P=1
make
```

### 运行示例
```
./Video_MIGraphX
根据提示选择要运行的示例程序，运行解码卡示例需要提前安装并初始化解码卡。比如执行:

如在CPU端解码，运行yolov3-tiny示例：
./Video_MIGraphX --cpu --net=0
```
注意：如果需要运行解码卡硬件帧示例，需要提前安装dma-buffer驱动

## result

![img](./Doc/image.gif)

### 精度
无

## 应用场景
### 算法类别
目标检测

### 热点应用行业
监控,交通,教育,化工

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/video_migraphx.git

## 参考资料
- https://github.com/WongKinYiu/yolov7
