﻿// 常用数据类型和宏定义

#ifndef __COMMON_DEFINITION_H__
#define __COMMON_DEFINITION_H__

#include <string>
#include <opencv2/opencv.hpp>

using namespace std;
using namespace cv;

namespace migraphxSamples
{
// memory deallocation
#define SAFE_DELETE(p)  { if ((p)) { delete (p); (p) = NULL; } }
#define SAFE_DELETE_ARRAY(p)  { if ((p)) { delete[] (p); (p) = NULL; } }

// 路径分隔符(Linux:‘/’,Windows:’\\’)
#ifdef _WIN32
#define  PATH_SEPARATOR '\\'
#else
#define  PATH_SEPARATOR '/'
#endif

#define CONFIG_FILE                                                     "../Resource/Configuration.xml"

// time
typedef struct  __Time
{
    string year;
    string month;
    string day;
    string hour;
    string minute;
    string second;
    string millisecond; // ms
    string microsecond; // us
    string weekDay;
}_Time;

// 错误码
typedef enum   _ErrorCode
{
    SUCCESS=0,  // 0
    MODEL_NOT_EXIST, // 模型不存在
    CONFIG_FILE_NOT_EXIST, // 配置文件不存在
    FAIL_TO_LOAD_MODEL, // 加载模型失败
    FAIL_TO_OPEN_CONFIG_FILE, // 加载配置文件失败
    IMAGE_ERROR, // 图像错误
}ErrorCode;

// 预测值:score label
typedef struct  _ResultOfPrediction
{
    float confidence; // score
    int label;
}ResultOfPrediction;

typedef struct  _InitializationParameterOfDetector
{
    std::string parentPath;
    std::string configFilePath;
    cv::Size inputSize;
    std::string logName;
}InitializationParameterOfDetector;

typedef struct  _InitializationParameterOfDecoder
{
    char str_devid[4] = {0};// = {0};
    const char *xcoder_params = NULL;// = "out=hw";
    const char *dec_name = NULL;// = "h264_ni_quadra_dec";
    //const char *filters_descr;// = "ni_quadra_scale=1280:720:format=yuv420p,hwdownload,format=yuv420p";
    //const char *filters_descr;// = "ni_quadra_scale=1280:720:format=rgba,hwdownload,format=rgba";
    const char *filters_descr = NULL;// = "ni_quadra_scale=1280:720:format=bgrp,hwdownload,format=bgrp";
    const char *src_filename = NULL;// = "../Resource/Images/Mean4.mp4";
}InitializationParameterOfDecoder;


typedef struct _InitializationParameterOfDetector InitializationParameterOfClassifier;
typedef struct _InitializationParameterOfDetector InitializationParameterOfOCR;

typedef struct  _ResultOfDetection
{
    Rect boundingBox;
    float confidence;
    int classID;
    string className;
    bool exist;

    _ResultOfDetection():confidence(0.0f),classID(0),exist(true){}

}ResultOfDetection;

struct OCRPredictResult {
  std::vector<std::vector<int>> box;
  std::string text;
  float score = -1.0;
  float cls_score;
  int cls_label = -1;
};

}

#endif // COMMONDEFINITION

