#include <cstring>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <Sample.h>
#include <getopt.h>
#include <SimpleLog.h>

void MIGraphXSamplesUsage()
{
    printf("Two args are required: ./a --cpu --net=0\n");
    printf("Usage : argc[1] --device_type argc[2] --net=index \n");
    printf("device_type: cpu / hw / dma\n");
    printf("index:\n");
    printf("\t 0) YOLOV3 sample.\n");
    printf("\t 1) YOLOV5 sample.\n");
    printf("\t 2) YOLOV7 sample.\n");
    printf("\t 3) SSD sample.\n");
    printf("\t 4) RetinaFace sample.\n");
}

static struct option long_options[] = {
    {"cpu", no_argument, NULL, 'c'},
    {"hw", no_argument, NULL, 'h'},
    {"dma", no_argument, NULL, 'd'},
    {"net", required_argument, NULL, 'n'},
    {NULL, 0, NULL, 0}
};

int main(int argc, char *argv[])
{
    if (argc < 3 || argc > 3)
    {
        MIGraphXSamplesUsage();
        return -1;
    }
    int opt, index;
    int device = -1;
    const char* Nets[] = {"YOLOV3", "YOLOV5", "YOLOV7", "SSD", "RetinaFace"};
    while ((opt = getopt_long(argc, argv, "chdn:", long_options, NULL)) != -1)
    {
        switch (opt)
        {
            case 'c':
                LOG_INFO(stdout, "Run SW Decode.\n");
                device = CPU;
                break;
            case 'h':
                LOG_INFO(stdout, "Run HW Decode and PCI to DCU.\n");
                device = _HW;
                break;
            case 'd':
                LOG_INFO(stdout, "Run HW Decode and DMA to DCU.\n");
                device = _HW_DMA;
                break;
            case 'n':
                index = atoi(optarg);
                LOG_INFO(stdout, "Run %s detector.\n", Nets[index]);
                break;
            case '?':
                MIGraphXSamplesUsage();
                return 0;
            default:
                MIGraphXSamplesUsage();
                return 0;
        }
    }
    switch (index)
    {
        case 0:
            {
                Sample_DetectorYOLOV3(device);
            }
            break;
        case 1:
            {
                Sample_DetectorYOLOV5(device);
            }
            break;
        case 2:
            {
                Sample_DetectorYOLOV7(device);
            }
            break;
        case 3:
            {
                Sample_DetectorSSD(device);
            }
            break;
        case 4:
            {
                Sample_DetectorRetinaFace(device);
            }
            break;
    }

    return 0;
}
