/* 
 * Decoder
 * 2022.09.23 sugon
 * */

#ifndef __DECODER_H__
#define __DECODER_H__

extern "C"
{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/poll.h>
#include <sys/time.h>

#include <libavcodec/avcodec.h>
#include <libavcodec/packet.h>
#include <libavcodec/codec.h>
#include <libavutil/imgutils.h>
#include <libavutil/samplefmt.h>
#include <libavutil/timestamp.h>
#include <libavformat/avformat.h>
#include <libavfilter/buffersink.h>
#include <libavfilter/buffersrc.h>
#include <libswscale/swscale.h>
#include <libavutil/time.h>
#include <libavutil/opt.h>

#ifdef DMA
#include <libavutil/hwcontext_ni_quad.h>
#include <ni_p2p_ioctl.h>

typedef struct HWContextType {
    enum AVHWDeviceType type;
    const char         *name;
    const enum AVPixelFormat *pix_fmts;
    size_t device_hwctx_size;
    size_t  device_priv_size;
    size_t device_hwconfig_size;
    size_t frames_hwctx_size;
    size_t  frames_priv_size;
    int (*device_create)(AVHWDeviceContext *ctx, const char *device, AVDictionary *opts, int flags);
    int (*device_derive)(AVHWDeviceContext *dst_ctx, AVHWDeviceContext *src_ctx, AVDictionary *opts, int flags);
    int (*device_init)(AVHWDeviceContext *ctx);
    void (*device_uninit)(AVHWDeviceContext *ctx);
    int (*frames_get_constraints)(AVHWDeviceContext *ctx, const void *hwconfig, AVHWFramesConstraints *constraints);
    int (*frames_init)(AVHWFramesContext *ctx);
    void (*frames_uninit)(AVHWFramesContext *ctx);
    int (*frames_get_buffer)(AVHWFramesContext *ctx, AVFrame *frame);
    int (*transfer_get_formats)(AVHWFramesContext *ctx, enum AVHWFrameTransferDirection dir, enum AVPixelFormat **formats);
    int (*transfer_data_to)(AVHWFramesContext *ctx, AVFrame *dst, const AVFrame *src);
    int (*transfer_data_from)(AVHWFramesContext *ctx, AVFrame *dst, const AVFrame *src);
    int (*map_to)(AVHWFramesContext *ctx, AVFrame *dst, const AVFrame *src, int flags);
    int (*map_from)(AVHWFramesContext *ctx, AVFrame *dst, const AVFrame *src, int flags);
    int (*frames_derive_to)(AVHWFramesContext *dst_ctx, AVHWFramesContext *src_ctx, int flags);
    int (*frames_derive_from)(AVHWFramesContext *dst_ctx, AVHWFramesContext *src_ctx, int flags);
} HWContextType;

struct AVHWFramesInternal {
    const HWContextType *hw_type;
    void                *priv;
    AVBufferPool *pool_internal;
    AVBufferRef *source_frames;
    int source_allocation_map_flags;
};
#endif

}

#include <CommonDefinition.h>
#include "hip/hip_runtime.h"
#include <hip/hip_runtime.h>

namespace migraphxSamples
{

struct DCU_Frame
{
    unsigned char* dcu_data;
    int data_len;
    int format = 0;
    int width;
    int height;
    cv::Mat srcImage;
};

class  Decoder
{
public:
    Decoder(int dev);
    ~Decoder();
    int DecoderInit(InitializationParameterOfDecoder initDecoder);
    #ifdef DMA
    int retrieve_filter_frame(DCU_Frame dcu_frame, AVFrame *src);
    #endif
    void setup_loglevel(char *loglevel);

    AVFormatContext *fmt_ctx = NULL;
    AVCodecContext *video_dec_ctx = NULL;
    AVFilterContext *buffersink_ctx;
    AVFilterContext *buffersrc_ctx;
    AVFilterGraph *filter_graph;

    AVStream *video_stream = NULL;
    AVFrame *frame = NULL;
    AVFrame *filt_frame = NULL;
    AVPacket *pkt = NULL;
    const AVCodec *dec = NULL;
    int video_stream_idx = -1;

private:
    int device = -1;
    int init_filters(const char *filters_descr);
};

}

#endif
