# Video_MIGraphX

## 目录
- [目录结构](#目录结构)
- [项目介绍](#项目介绍)
- [环境配置](#环境配置)
- [编译运行](#编译运行)
- [参考文档](#参考文档)
- [历史版本](#历史版本)

## 目录结构
```
├── CMakeLists.txt
├── Doc
├── include
├── lib
│   ├── libdecode0.so
│   ├── libdecode1.so
│   └── libQueue.so
├── README.md
├── Resource
│   ├── Configuration.xml
│   ├── Images
│   └── Models
└── src
    ├── Inference
    ├── main.cpp
    ├── RetinaFace.cpp
    ├── SSD.cpp
    ├── Utility
    ├── YOLOV3.cpp
    ├── YOLOV5.cpp
    └── YOLOV7.cpp
```

## 项目介绍

基于CPU和解码卡解码的视频推理范例

## 环境配置

推荐使用docker方式运行，提供[光源](https://www.sourcefind.cn/#/service-list)拉取的docker镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:decode-ffmpeg-dtk23.04
```

## 编译运行

### 编译
```
git clone https://developer.hpccube.com/codes/modelzoo/video_migraphx
cd video_migraphx
mkdir build
cd build
使用CPU解码和解码卡软件帧：
cmake ../ -DUSE_P2P=0
使用解码卡硬件帧：
cmake ../ -DUSE_P2P=1
make
```

### 运行
```
./Video_MIGraphX
```
根据提示选择要运行的示例程序，运行解码卡示例需要提前安装并初始化解码卡。比如执行:
```
./Video_MIGraphX --cpu --net=0
```
运行CPU解码并运行YOLOV3推理示例程序


## 参考文档

文档参考Doc目录下说明文档.

## 历史版本

https://developer.hpccube.com/codes/modelzoo/video_migraphx

