# VGG16

## 论文

VERY DEEP CONVOLUTIONAL NETWORKS FOR LARGE-SCALE IMAGE RECOGNITION

- https://arxiv.org/abs/1409.1556

## 模型介绍

VGG模型是2014年ILSVRC竞赛的第二名，第一名是GoogLeNet。但是VGG模型在多个迁移学习任务中的表现要优于GoogLeNet。而且，从图像中提取CNN特征，VGG模型是首选算法。

![20231124132639](./images/20231124132639.png)

## 模型结构

VGG16共有16个层，是一个相当深的卷积神经网络。VGG各种级别的结构都采用了5段卷积，每一段有一个或多个卷积层。

![20231124132925](./images/20231124132925.png)

## 环境配置

### Docker

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/vgg16_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=nit-pytorch --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/VGG16_mmcv:/home/VGG16_mmcv -it <your IMAGE ID> bash

cd VGG16_mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

```
├── meta
├── train
├── val
```

### 训练

将训练数据解压到data目录下。

### 单机8卡

    ./vgg16.sh

## 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |          精度           |
| :--: | :---------------------: |
|  8   | top1:0.7162;top5:0.9049 |

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/vgg16_mmcv

### 参考

https://github.com/open-mmlab/mmpretrain