# VGG16

## 论文

VERY DEEP CONVOLUTIONAL NETWORKS FOR LARGE-SCALE IMAGE RECOGNITION

- https://arxiv.org/abs/1409.1556

## 模型结构

VGG模型是2014年ILSVRC竞赛的第二名，第一名是GoogLeNet。但是VGG模型在多个迁移学习任务中的表现要优于GoogLeNet。而且，从图像中提取CNN特征，VGG模型是首选算法。

![20231124132639](./images/20231124132639.png)

## 算法原理

VGG16共有16个层，是一个相当深的卷积神经网络。VGG各种级别的结构都采用了5段卷积，每一段有一个或多个卷积层。

![20231124132925](./images/20231124132925.png)

## 环境配置

### Docker（方法一）

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/vgg16_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=nit-pytorch --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/vgg16_mmcv:/home/vgg16_mmcv -it <your IMAGE ID> bash

cd vgg16_mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

### Dockerfile（方法二）

```plaintext
cd vgg16_mmcv/docker
docker build --no-cache -t vgg16_mmcv:latest .
docker run --rm --shm-size 10g --network=host --name=megatron --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/../../vgg16_mmcv:/home/vgg16_mmcv -it megatron bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt
```

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```plaintext
DTK驱动：dtk22.10.1
python：python3.7
torch:1.10.0
torchvision:0.10.0
mmcv：1.6.1
Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应
```

2、其它非特殊库参照requirements.txt安装

```plaintext
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

下载ImageNet数据集：https://image-net.org/

下载val数据：链接：https://pan.baidu.com/s/1oXsmsYahGVG3uOZ8e535LA?pwd=c3bc 提取码：c3bc 替换ImageNet数据集中的val目录，处理后的数据结构如下：

```
├── meta
├── train
├── val
```

## 训练

将训练数据解压到data目录下。

### 单机8卡

    ./vgg16.sh

## 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |          精度           |
| :--: | :---------------------: |
|  8   | top1:0.7162;top5:0.9049 |

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/vgg16_mmcv

### 参考

https://github.com/open-mmlab/mmpretrain