# veros

## 论文

**Veros v0.1 – a fast and versatile ocean simulator in pure Python**

* https://gmd.copernicus.org/articles/11/3299/2018/

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/jax:0.4.23-ubuntu20.04-dtk24.04.1-py3.10

    docker run --shm-size 10g --network=host --name=veros --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    python setup.py develop


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 10g --network=host --name=idmvton --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    python setup.py develop


### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk24.04
    python：python3.10
    jax: 0.4.23

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

    python setup.py develop

## 数据集

无

## 推理

### 快速应用

    # 以下是两个基本使用方法，可以查看`veros/setups`中的文件并对命令行进行相应的修改
    veros copy-setup acc 
    veros run acc/acc.py -b jax --device gpu --float-type float32

    veros copy-setup global_4deg
    veros run global_4deg/global_4deg.py -b jax --device gpu --float-type float32

注意：更多使用方法参考`https://veros.readthedocs.io/en/latest/introduction/introduction.html`

### benchmark

    cd benchmarks

    python acc_benchmark.py --timesteps 100 --size 30 42 15 -b jax --device gpu --float-type float32

    python isoneutral_benchmark.py --timesteps 100 --size 30 42 15 -b jax --device gpu --float-type float32

    python pressure_solver_benchmark.py --timesteps 100 --size 30 42 15 -b jax --device gpu --float-type float32

    python streamfunction_solver_benchmark.py --timesteps 100 --size 30 42 15 -b jax --device gpu --float-type float32

    python tdma_benchmark.py --timesteps 100 --size 30 42 15 -b jax --device gpu --float-type float32

### 数据分析

    analyze.ipynb

注意：需要启动`jupyter`运行该程序。


## result

||psi|salt|temp|vsf_depth|
|:---:|:---:|:---:|:---:|:---:|
|K100_AI|![alt text](readme_imgs/image.png)|![alt text](readme_imgs/image-3.png)|![alt text](readme_imgs/image-5.png)|![alt text](readme_imgs/image-7.png)|
|均值/方差|11.8371/26.338|35.00005/0.00026633|8.96047/4.736734|-0.18298379/3.6047194|
|A800|![alt text](readme_imgs/image-1.png)|![alt text](readme_imgs/image-4.png)|![alt text](readme_imgs/image-6.png)|![alt text](readme_imgs/image-8.png)|
|均值/方差|11.838/26.3398|34.99996/0.0003391|8.960432/4.7367105|-0.1834556/3.602966|


### 精度

无

## 应用场景

`海洋模拟`

### 热点应用行业

`气象,能源,海洋`

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/veros_jax

## 参考资料

* https://github.com/team-ocean/veros
