# Vary-toy:
**免费开源多模态OCR大模型**

## 论文

- [论文地址][Small Language Model Meets with Reinforced Vision Vocabulary](https://arxiv.org/abs/2401.12503)

- [Vary-toy weights huggingface 预训练模型下载地址]<https://huggingface.co/Haoran-megvii/Vary-toy>

- [Download the CLIP-VIT-L]<https://huggingface.co/openai/clip-vit-large-patch14/>

## 模型结构

### Vary-toy模型结构
<div align="center">
<img align="center" src=image/model.png>
</div>


## 算法原理
Vary-toy 利用 Vary-tiny+ 管道来生成新的愿景 Vary-toy的词汇。这样的视觉词汇可以有效地编码密集的文本和自然物体位置信息转换为令牌。基于改进的词汇量，Vary-toy 不仅拥有所有以前的功能（文档OCR），但也很好地处理了对象检测任务。



## 环境配置
### Docker（方法一）

注：在部署环境前需将Vary-toy/vary/demo/run_qwen_vary.py和Vary-toy/vary/model/vary_qwen_vary.py和Vary-toy/vary/model/vary_toy_qwen1_8.py中的模型路径改为本地模型路径，同时将Vary-toy/cache/models--HaoranWei--Vary-toy模型中的config.json文件中的模型路径改为本地路径，完成以上操作后再执行pip install e .指令。
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk23.10.1-py310

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=64G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name vary-toy <your imageID> bash

docker exec -it vary-toy bash

cd /path/your_code_data/vary-toy

pip install e .

pip install ninja
```
### Dockerfile（方法二）
```
cd /path/your_code_data/vary-toy/docker

docker build --no-cache -t vary-toy:latest .

docker run --shm-size=64G --name vary-toy -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /path/your_code_data/:/path/your_code_data/ -it vary-toy bash
```
### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

```
DTK驱动：dtk23.10
python：python3.10
torch:2.1
torchvision: 0.16.0
deepspped: 0.12.3
```
```
conda create -n vary-toy python=3.10

conda activate vary-toy

cd /path/your_code_data/vary-toy

pip install e .

pip install ninja
```


`Tips：以上dtk驱动、python、torch、deepspeed等DCU相关工具版本需要严格一一对应`

## 数据集

无, 暂未开放数据集


## 训练

需自己构建数据集

```
deepspeed   Vary/train/train_qwen_vary.py  --deepspeed /Vary/zero_config/zero2.json
            --model_name_or_path /Vary-toy/path/
            --vision_tower /vit-large-patch14/path/
            --freeze_vision_tower True
            --freeze_lm_model False
            --vision_select_layer  -2
            --use_im_start_end True
            --bf16 True
            --per_device_eval_batch_size 4
            --gradient_accumulation_steps 1
            --evaluation_strategy "no"
            --save_strategy "steps"
            --save_steps 5000
            --save_total_limit 1
            --weight_decay 0.
            --warmup_ratio 0.03
            --lr_scheduler_type "cosine"
            --logging_steps 1 --tf32 True
            --model_max_length 4096
            --gradient_checkpointing True
            --dataloader_num_workers 4
            --report_to none
            --per_device_train_batch_size 4
            --num_train_epochs 1
            --learning_rate 5e-5
            --datasets  data_name1+data_name2+data_name3
            --output_dir /path/to/output/
```

## 推理

**需严格按照本仓库代码目录进行排列**

备注：修改 --image-file 替换ocr文件

```
python /home/wanglch/projects/Vary-toy/vary/demo/run_qwen_vary.py --model-name /home/wanglch/projects/Vary-toy/cache/models--HaoranWei--Vary-toy --image-file /home/wanglch/projects/Vary-toy/image/pic.jpg
```

备注：修改 vary/demo/run_qwen_vary.py 替换57行代码执行不同任务操作

```
qs = 'Provide the ocr results of this image.' # 执行ocr任务
qs = 'Detevate the ** in this image.' # 检测任务
qs = 'Convert the document to markdown format.' # 公式转markdown
qs = 'Describe this image in within 100 words.' # 多模态描述
```
### 推理代码
```
bash run.sh
```

## result
### 英语文档ocr

<div align="center">
<img align="center" src=image/ocr_en.png>
</div>

### 中文文档ocr
<div align="center">
<img align="center" src=image/ocr_en.png>
</div>


### 车牌识别ocr

<div align="center">
<img align="center" src=image/car.png>
</div>

<div align="center">
<img align="center" src=image/car_number.png>
</div>


### 精度
无

## 应用场景

金融,教育,政府,科研,交通,医疗

### 算法类别

图文OCR

## 预训练权重
- Vary-toy 权重下载 [here](https://huggingface.co/Haoran-megvii/Vary-toy). 
- CLIP-VIT-L 权重下载 [here](https://huggingface.co/openai/clip-vit-large-patch14/).
   

## 参考资料
- 本项目gitlab地址[Ucas-HaoranWei/Vary-toy](https://github.com/Ucas-HaoranWei/Vary-toy/tree/main)

