# MiniMax-M2
## 论文
[UniMERNet](https://arxiv.org/abs/2404.15254)

## 模型简介
UniMERNet 是一个深度学习模型，专注于数学公式的识别。它可以从手写或打印的数学公式图像中提取出精确的数学表达式，并将其转换为 LaTeX 代码。LaTeX 是广泛应用于数学、科学和技术领域的排版系统，因此，能够将数学公式转换为 LaTeX 代码对于公式的展示和编辑至关重要。

**主要特点：**
**高精度识别：** 支持手写和打印数学公式的高精度识别。
**实时渲染：** 通过 Streamlit 和 LaTeX 渲染，您可以实时查看公式识别结果。
**多平台支持：** UniMERNet 可以在 Windows、Linux 和 macOS 等操作系统上运行。


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.8e22ded.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name minimax_m2 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
### 介绍
UniMER 数据集是一个专门收集的集合，旨在推进数学表达式识别（MER）领域。它包括全面的 UniMER-1M 训练集，包含超过一百万个实例，代表了多样且复杂的数学表达式，以及精心设计的 UniMER 测试集，用于基准测试 MER 模型在真实世界场景中的表现。数据集详情如下：

**UniMER-1M 训练集：**
  - 总样本数：1,061,791 对 LaTeX-图像对
  - 组成：简洁和复杂的扩展公式表达的平衡混合
  - 目的：训练鲁棒、高精度的 MER 模型，提高识别精度和泛化能力

**UniMER 测试集：**
  - 总样本数：23,757 个，分为四种表达式类型：
    - 简单打印表达式（SPE）：6,762 个样本
    - 复杂打印表达式（CPE）：5,921 个样本
    - 屏幕截图表达式（SCE）：4,742 个样本
    - 手写表达式（HWE）：6,332 个样本
  - 目的：在各种真实世界条件下对 MER 模型进行全面评估

### 数据集下载
你可以从 [OpenDataLab](https://opendatalab.com/OpenDataLab/UniMER-Dataset)（推荐中国用户）或 [HuggingFace](https://huggingface.co/datasets/wanderkid/UniMER_Dataset) 下载数据集。


## 训练
要训练 UniMERNet 模型，请按照以下步骤操作：

1. **指定训练数据集路径**：打开 `configs/train` 文件夹并设置你的训练数据集路径。

2. **运行训练脚本**：执行以下命令以开始训练过程。

    ```bash
    bash script/train.sh
    ```

### 注意：
- 确保 `configs/train` 文件夹中指定的数据集路径是正确且可访问的。
- 监控训练过程中的任何错误或问题。

## 推理
模型权重
```bash
git clone https://github.com/opendatalab/UniMERNet.git
```

```bash
cd UniMERNet/models
# 单独下载模型和分词器或使用 git-lfs
git lfs install
git clone https://huggingface.co/wanderkid/unimernet_base  # 1.3GB  
git clone https://huggingface.co/wanderkid/unimernet_small # 773MB  
git clone https://huggingface.co/wanderkid/unimernet_tiny  # 441MB  

# 你也可以从 ModelScope 下载模型
git clone https://www.modelscope.cn/wanderkid/unimernet_base.git
git clone https://www.modelscope.cn/wanderkid/unimernet_small.git
git clone https://www.modelscope.cn/wanderkid/unimernet_tiny.git
```

. **Streamlit 应用程序**：使用我们的基于 Streamlit 的 GUI 进行交互和用户友好的体验。此应用程序允许实时公式识别和渲染。

    ```bash
    unimernet_gui
    ```
    确保你已安装最新版本的 UniMERNet (`pip install --upgrade unimernet & pip install "unimernet[full]"`) 以使用 Streamlit GUI 应用程序。

2. **命令行演示**：从图像中预测 LaTeX 代码。

    ```bash
    python demo.py
    ```

3. **Jupyter Notebook 演示**：从图像中识别和渲染公式。

    ```bash
    jupyter-lab ./demo.ipynb
    ```


## 效果展示
暂无
### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| unimernet_base | 1.3GB | K100AI | 1 | [下载地址](https://huggingface.co/wanderkid/unimernet_base) |
| unimernet_small | 1.3GB | K100AI | 1 | [下载地址](https://huggingface.co/wanderkid/unimernet_small) |
| unimernet_tiny | 1.3GB | K100AI | 1 | [下载地址](https://huggingface.co/wanderkid/unimernet_tiny ) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/unimernet_transformers

## 参考资料
- https://github.com/opendatalab/UniMERNet
