# Uni-Fold(An Open-Source Platform for Developing Protein Folding Models beyond AlphaFold)
## 模型介绍

深势科技推出的蛋白质结构预测工具Uni-Fold，成功复现曾引起生物学界轰动的 AlphaFold2 的全规模训练，并开源训练代码与推理代码。相应解决方案已集成至深势科技自主研发的药物设计平台 Hermite，供广大用户测试使用。

Uni-Fold 克服了AlphaFold2 未开源训练代码、硬件支持单一、模型不可商用等局限性，在训练与推理环节进行了 NVIDIA GPU上的适配、性能优化及功能完善等工作，为更多人参与推动领域进一步发展提供了基础。

## 模型结构

Uni-Fold,参考https://github.com/dptech-corp/Uni-Fold

## Uni-Fold代码参考版本

版本：master

原始代码位置：https://github.com/dptech-corp/Uni-Fold.git

## 数据集

示例中验证的数据集来自：

```
bash scripts/download/download_all_data.sh /path/to/database/directory
```

## 预训练模型参数
```
wget https://github.com/dptech-corp/Uni-Fold/releases/download/v2.0.0/unifold_params_2022-08-01.tar.gz

tar -zxf unifold_params_2022-08-01.tar.gz
```
## 推理

### 环境配置

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 推理镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:unifold-latest

cd /root/Uni-Fold-main
```
* 依赖安装：(如使用镜像，则无需再次安装)

安装requirement.txt中的工具，镜像中已经安装好,加载方式
```
export PATH=/root/software/hmmer/bin${PATH:+:${PATH}}

export PATH=/root/software/hh-suite-master/bin${PATH:+:${PATH}}

export PATH=/root/software/kalign/bin${PATH:+:${PATH}}

export LD_LIBRARY_PATH=/root/software/hh-suite-master/lib${LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}
```
### 安装
#### 安装Uni-Core-main(如使用镜像，则无需再次安装)
```
cd Uni-Core-main

export CUDA_HOME=/opt/dtk-22.04.2

python3 setup.py install
```
#### 安装Uni-Fold-main(如使用镜像，则无需再次安装)
```
pip install -e .
```
### 单卡测试
#### 多聚体参考脚本,需要根据实际情况修改路径配置
```
sh run_multimer.sh 
```
#### 单聚体参考脚本,需要根据实际情况修改路径配置
```
sh run_monomer.sh
```
## 源码仓库及问题反馈 
* https://developer.hpccube.com/codes/modelzoo/uni-fold

## 参考
* https://github.com/dptech-corp/Uni-Fold 

