# Uni-Fold

## 论文
`Uni-Fold: An Open-Source Platform for Developing Protein Folding Models beyond AlphaFold`
- https://www.biorxiv.org/content/biorxiv/early/2022/08/06/2022.08.04.502811.full.pdf

## 模型结构
模型核心是一个基于Transformer架构的神经网络，包括两个主要组件：Sequence to Sequence Model和Structure Model，这两个组件通过迭代训练进行优化，以提高其预测准确性。

![img](./alphafold2.png)

## 算法原理
通过从蛋白质序列和结构数据中提取信息，使用神经网络模型来预测蛋白质三维结构。

![img](./alphafold2_1.png)

## 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:unifold-torch2.1.0-dtk24.04.2-ubuntu20.04-py310

docker run -it --network=host  -v <unifold代码路径>:<容器内路径> --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video  -v /opt/hyhal:/opt/hyhal:ro -v /opt/dtk-24.04.2-runtime/:/opt/dtk/:ro  --name <镜像名称> <上面获得的镜像ID> bash

cd /root/Uni-Fold
```

进行homosearch需要挂载AF2数据集至容器内`/alphafold`，若只为测试，本镜像无需挂载AF2数据集。
因为本镜像在昆山K100_AI的eco卡节点测试，dtk24.04.2不能正常使用，测试时挂载dtk-24.04.2-runtime至/opt/dtk。若确认本节点dtk24.04.2能正常使用可以选择不挂载，并修改/root目录下的/env.sh及Uni-Fold目录中的/opt/dtk为/opt/dtk-24.04.2

镜像版本依赖：
* DTK驱动：dtk24.04.2
* Pytorch: 2.1.0
* unifold: 2.2.0
* unicore: 0.0.1
* python: 3.10

测试目录：
`/root/Uni-Fold`

安装requirement.txt中的工具，镜像中已经安装好加载方式：

```
source /root/env.sh
```

若报错`rm: cannot remove 'software': No such file or directory`等不必理会，其中的rm命令只是希望删除两个空文件夹。

## 数据集
推荐使用[AlphaFold2](http://113.200.138.88:18080/aidatasets/project-dependency/alphafold)中的开源数据集，包括BFD、MGnify、PDB70、Uniclust、Uniref90等,数据集大小约2.62TB。数据集格式如下：
```
$DOWNLOAD_DIR/
    bfd/
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_hhm.ffindex
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_hhm.ffdata
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_cs219.ffindex
        ...
    mgnify/
        mgy_clusters_2022_05.fa
    params/
        params_model_1.npz
        params_model_2.npz
        params_model_3.npz
        ...
    pdb70/
        pdb_filter.dat
        pdb70_hhm.ffindex
        pdb70_hhm.ffdata
        ...
    pdb_mmcif/
        mmcif_files/
            100d.cif
            101d.cif
            101m.cif
            ...
        obsolete.dat
    pdb_seqres/
        pdb_seqres.txt
    small_bfd/
        bfd-first_non_consensus_sequences.fasta
    uniref30/
        UniRef30_2021_03_hhm.ffindex
        UniRef30_2021_03_hhm.ffdata
        UniRef30_2021_03_cs219.ffindex
        ...
    uniprot/
        uniprot.fasta
    uniref90/
        uniref90.fasta
```

此处提供了一个脚本download_all_data.sh用于下载使用的数据集和模型文件：

```
bash scripts/download/download_all_data.sh /path/to/database/directory
```

## 推理
### 安装
#### 安装Uni-Core-main(如使用镜像，则无需再次安装)
```
cd Uni-Core-main

python3 setup.py install
```

#### 安装Uni-Fold-main(如使用镜像，则无需再次安装)
```
pip install -e .
```

### 多卡测试

如果没有挂载AF2数据集，会出现多体、单体测试脚本运行homosearch中报错`ValueError: Could not find hmmsearch database /alphafold/pdb_seqres/pdb_seqres.txt`并停止搜索、直接进行推理的情况，由于单本镜像内置了部分序列的搜索结果，因此可以无视此报错进行正常推理。
内置搜索结果的目录见`/root/Uni-Fold/data`，其中有H1036、H1072、T1024的搜索结果，若要选择其他序列进行推理，请挂载AF2数据集并进行homosearch（非常耗时）。

#### 多聚体参考脚本,需要根据实际情况修改路径配置
```
bash run_multimer.sh
```

#### 单聚体参考脚本,需要根据实际情况修改路径配置
```
bash run_monomer.sh
```

## result
![img](./result_pdb.png)

### 精度
无

## 应用场景
### 算法类别
蛋白质结构预测

### 热点应用行业
医疗,科研,教育

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/uni-fold

## 参考资料
- https://github.com/dptech-corp/Uni-Fold
