# Uni-Fold

## 论文

Uni-Fold: An Open-Source Platform for Developing Protein Folding Models beyond AlphaFold
https://www.biorxiv.org/content/biorxiv/early/2022/08/06/2022.08.04.502811.full.pdf
## 模型结构
模型核心是一个基于Transformer架构的神经网络，包括两个主要组件：Sequence to Sequence Model和Structure Model，这两个组件通过迭代训练进行优化，以提高其预测准确性。

![img](./alphafold2.png)

## 算法原理
通过从蛋白质序列和结构数据中提取信息，使用神经网络模型来预测蛋白质三维结构。

![img](./alphafold2_1.png)

## 环境配置

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:unifold-latest
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /root/Uni-Fold-main
```
安装requirement.txt中的工具，镜像中已经安装好,加载方式
```
export PATH=/root/software/hmmer/bin${PATH:+:${PATH}}

export PATH=/root/software/hh-suite-master/bin${PATH:+:${PATH}}

export PATH=/root/software/kalign/bin${PATH:+:${PATH}}

export LD_LIBRARY_PATH=/root/software/hh-suite-master/lib${LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}
```
## 数据集
推荐使用AlphaFold2中的开源数据集，包括BFD、MGnify、PDB70、Uniclust、Uniref90等,数据集大小约2.62TB。数据集格式如下：
```
$DOWNLOAD_DIR/                             
    bfd/  
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_hhm.ffindex
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_hhm.ffdata 
        bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt_cs219.ffindex                           
        ...
    mgnify/                                
        mgy_clusters_2022_05.fa
    params/                                
        params_model_1.npz
        params_model_2.npz
        params_model_3.npz
        ...
    pdb70/                                
        pdb_filter.dat
        pdb70_hhm.ffindex
        pdb70_hhm.ffdata
        ...
    pdb_mmcif/                            
        mmcif_files/
            100d.cif
            101d.cif
            101m.cif
            ...
        obsolete.dat
    pdb_seqres/                            
        pdb_seqres.txt
    small_bfd/                           
        bfd-first_non_consensus_sequences.fasta
    uniref30/                            
        UniRef30_2021_03_hhm.ffindex
        UniRef30_2021_03_hhm.ffdata
        UniRef30_2021_03_cs219.ffindex
        ...
    uniprot/                               
        uniprot.fasta
    uniref90/                             
        uniref90.fasta
```
此处提供了一个脚本download_all_data.sh用于下载使用的数据集和模型文件：
```
bash scripts/download/download_all_data.sh /path/to/database/directory
```

## 推理

### 安装
#### 安装Uni-Core-main(如使用镜像，则无需再次安装)
```
cd Uni-Core-main

export CUDA_HOME=/opt/dtk-22.04.2

python3 setup.py install
```
#### 安装Uni-Fold-main(如使用镜像，则无需再次安装)
```
pip install -e .
```
### 多卡测试
#### 多聚体参考脚本,需要根据实际情况修改路径配置
```
sh run_multimer.sh 
```
#### 单聚体参考脚本,需要根据实际情况修改路径配置
```
sh run_monomer.sh
```
## result
无

### 精度
无
## 应用场景

### 算法类别
蛋白质结构预测

### 热点应用行业
医疗,科研,教育

## 源码仓库及问题反馈 
* https://developer.hpccube.com/codes/modelzoo/uni-fold

## 参考资料
* https://github.com/dptech-corp/Uni-Fold 

