// !!! This is a file automatically generated by hipify!!!
#include "hip/hip_runtime.h"
#include <vector>
#include <ATen/ATen.h>
#include <ATen/hip/HIPGeneratorImpl.h>
#include <ATen/hip/detail/IndexUtils.cuh>
#include <ATen/hip/detail/TensorInfo.cuh>
#include <c10/hip/HIPMathCompat.h>
#include <hip/hip_runtime.h>
#include <hip/hip_runtime.h>
#include <hip/hip_fp16.h>
#include <cuda_bf16.h>
#include <hiprand_kernel.h>
#include <ATen/hip/HIPContext.h>
#include <torch/extension.h>
#include <math.h>
#include <iostream>

union float_int_32
{
    uint32_t i;
    float f;
};

__global__ void fp32_to_bf16(
    const float* input,
    nv_bfloat16* output,
    const int tsize,
    uint64_t seed,
    uint64_t offset) {

    int i = threadIdx.x + blockIdx.x * blockDim.x;
    if (i < tsize) {
        float_int_32 d;
        d.f = input[i];
        hiprandStatePhilox4_32_10_t state;
        hiprand_init(seed, i, offset, &state);
        d.i += hiprand(&state) & 0x0000ffff;
        output[i] = __float2bfloat16_rz(d.f);
    }
}

void fused_fp32_to_bf16_sr_cuda(
    at::Tensor & input,
    at::Tensor & output)
{
    int tsize = input.numel();
    const int threadsPerBlock = 512;
    const int blocks = (tsize + threadsPerBlock - 1) / threadsPerBlock;
    AT_ASSERTM(at::cuda::detail::canUse32BitIndexMath(input), "parameter tensor is too large to be indexed with int32");
    AT_ASSERTM(input.scalar_type() == at::ScalarType::Float, "expected input to be float32 tensor");
    AT_ASSERTM(output.scalar_type() == at::ScalarType::BFloat16, "expected output to be bfloat16 tensor");
    auto gen = at::cuda::detail::getDefaultCUDAGenerator();
    std::pair<uint64_t, uint64_t> rng_engine_inputs;
    {
        // See Note [Acquire lock when using random generators]
        std::lock_guard<std::mutex> lock(gen.mutex());
        rng_engine_inputs = at::check_generator<at::CUDAGeneratorImpl>(gen)->philox_engine_inputs(1);
    }
    uint64_t seed = std::get<0>(rng_engine_inputs);
    uint64_t offset = std::get<1>(rng_engine_inputs);
    hipStream_t stream = at::hip::getCurrentHIPStreamMasqueradingAsCUDA();
   hipLaunchKernelGGL(( fp32_to_bf16), dim3(blocks), dim3(threadsPerBlock), 0, stream, 
        (const float*)input.data_ptr(),
        (nv_bfloat16*)output.data_ptr(),
        tsize,
        seed,
        offset);
    AT_CUDA_CHECK(hipGetLastError());
}

