#!/bin/bash
export DTKROOT=/opt/dtk
export AMDGPU_TARGETS="gfx928"
export ROCMVER=24.04.2
export DTK_HOME=/opt/dtk
export ROCM_PATH=${DTK_HOME}
export HIP_PATH=${DTK_HOME}/hip
export PATH=${DTK_HOME}/bin:${DTK_HOME}/llvm/bin:${DTK_HOME}/hip/bin:${DTK_HOME}/miopen/bin:$PATH
export LD_LIBRARY_PATH=${DTK_HOME}/lib:${DTK_HOME}/lib64:${DTK_HOME}/hip/lib:${DTK_HOME}/llvm/lib:${DTK_HOME}/miopen/lib:$LD_LIBRARY_PATH
export INCLUDE=${DTK_HOME}/include:${DTK_HOME}/hip/include:${DTK_HOME}/llvm/include:$INCLUDE
export C_INCLUDE_PATH=${DTK_HOME}/include:${DTK_HOME}/hip/include:${DTK_HOME}/llvm/include:$C_INCLUDE_PATH
export CPLUS_INCLUDE_PATH=${DTK_HOME}/include:$CPLUS_INCLUDE_PATH
export MIOPEN_SYSTEM_DB_PATH=${DTK_HOME}/miopen/share/miopen/db/
source ./env.sh

cd /root/Uni-Fold
fasta_path=/root/Uni-Fold/data/T1024.fasta
input_dir_base=/root/Uni-Fold/data
output_dir_base=/root/Uni-Fold/data
database_dir=/alphafold/
max_template_date=2020-05-01
model_name=model_2_ft
param_path=/root/Uni-Fold/Alphafold/monomer.unifold.pt 

echo "Starting homogeneous searching..."
python unifold/homo_search.py \
    --fasta_path=$fasta_path \
    --max_template_date=$max_template_date \
    --output_dir=$output_dir_base  \
    --uniref90_database_path=$database_dir/uniref90/uniref90.fasta \
    --mgnify_database_path=$database_dir/mgnify/mgy_clusters_2018_12.fa \
    --bfd_database_path=$database_dir/bfd/bfd_metaclust_clu_complete_id30_c90_final_seq.sorted_opt \
    --uniclust30_database_path=$database_dir/uniclust30/uniclust30_2018_08/uniclust30_2018_08 \
    --uniprot_database_path=$database_dir/uniprot/uniprot.fasta  \
    --pdb_seqres_database_path=$database_dir/pdb_seqres/pdb_seqres.txt \
    --template_mmcif_dir=$database_dir/pdb_mmcif/mmcif_files \
    --obsolete_pdbs_path=$database_dir/pdb_mmcif/obsolete.dat \
    --use_precomputed_msas=True


echo "Starting prediction..."
fasta_file=$(basename $fasta_path)
target_name=${fasta_file%.fa*}

python3 unifold/inference.py \
        --model_name=$model_name \
        --param_path=$param_path \
        --data_dir=$input_dir_base \
        --target_name=$target_name \
        --output_dir=$output_dir_base 
