# Unet_Paddle算力测试

## 1.模型介绍

Unet_Paddle是一种常用于图像分割任务的深度学习模型，由Ronneberger等人于2015年提出。它的名称来自其U形的网络结构，它由编码路径和解码路径两部分组成，具有以下特点：

1. U-Net的编码路径是由一系列的卷积层和池化层组成，可以将输入图像不断缩小，提取出图像的高层次特征。
2. U-Net的解码路径是由一系列的反卷积层和上采样层组成，可以将编码路径中提取出来的特征重新放大，并与原始图像进行连接，以便恢复图像的分辨率和细节信息。
3. U-Net使用了跳跃连接（skip connections）的技术，将编码路径中的特征图与解码路径中的特征图进行连接，从而可以将低层次的特征信息与高层次的特征信息相结合，提高了模型的准确性和鲁棒性。
4. U-Net的损失函数通常使用交叉熵或Dice系数等指标，用于衡量模型对图像分割的准确性。

U-Net模型在医学图像分割、卫星图像分割、自然图像分割等领域都得到了广泛的应用。它具有良好的灵活性和可扩展性，可以根据具体的任务和数据集进行适当的修改和调整。同时，U-Net模型的训练也比较快速和稳定，可以使用较小的数据集进行训练，并且具有较好的泛化能力。



## 2.模型结构

U-Net模型的结构可以分为编码路径和解码路径两部分，其总体结构呈现出U字形，因此得名U-Net。下面是U-Net模型的结构特点：

1. 编码路径：U-Net模型的编码路径由一系列的卷积层和池化层组成，用于提取图像的高层次特征。每一层卷积层后都跟随一个下采样操作，通常是最大池化（Max Pooling）操作，以便将特征图的尺寸不断缩小。这使得模型可以从图像中提取出不同层次的特征，从而对不同大小、复杂度的目标进行更好的识别和分割。
2. 解码路径：U-Net模型的解码路径由一系列的反卷积层和上采样层组成，用于将编码路径中提取出来的特征图重新放大，并与原始图像进行连接，以便恢复图像的分辨率和细节信息。每一层反卷积层后都跟随一个上采样操作，通常是转置卷积（Transpose Convolution）操作，以便将特征图的尺寸不断放大。这使得模型可以从编码路径中提取的特征图中重新恢复出原始图像的细节信息，从而得到更精细的分割结果。
3. 跳跃连接：U-Net模型使用了跳跃连接（skip connections）的技术，将编码路径中的特征图与解码路径中的特征图进行连接，从而可以将低层次的特征信息与高层次的特征信息相结合，提高了模型的准确性和鲁棒性。具体来说，U-Net模型将编码路径中的特征图与解码路径中相同层次的特征图进行连接，这样就可以将编码路径中提取的低层次特征信息与解码路径中提取的高层次特征信息进行融合，从而得到更准确的分割结果。
4. 损失函数：U-Net模型的损失函数通常使用交叉熵或Dice系数等指标，用于衡量模型对图像分割的准确性。在使用交叉熵作为损失函数时，U-Net模型通常采用softmax函数将输出的得分转换成概率值，从而计算损失。在使用Dice系数作为损失函数时，U-Net模型将输出的得分直接与真实标签进行比较，从而计算损失。

## 3. 数据集

模型使用[The Cityscapes Dataset ](https://www.cityscapes-dataset.com/) 

提出了一个新的大规模数据集，该数据集包含了来自50个不同城市的街道场景中记录的各种立体视频序列，除了20 000帧弱注释帧外，还具有5 000帧的高质量像素级注释。因此，该数据集比之前类似的尝试要大一个数量级。

The Cityscapes Dataset的目的是:

- 评估视觉算法在语义城市场景理解的主要任务中的性能:像素级、实例级和全视语义标记;
- 支持旨在利用大量(弱)注释数据的研究，例如用于训练深度神经网络。

## 4.训练

### 环境配置

提供光源拉取的训练镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/paddlepaddle:2.3.2-centos7.6-dtk-22.10-py38-latest
```

python依赖安装：

```
opencv-python==3.4.10.35
PyYAML==6.0
sklearn==0.0
filelock==3.9.0
visualdl==2.5.0
```

之后在PaddleSeg目录下执行：

```
pip install -e .
```

在PaddleSeg目录下创建data文件夹并在下面创建数据集cityscapes的软连接如下：

![1](1.png)

在PaddleSeg目录下执行如下命令对数据集进行预处理

```
pip install cityscapesscripts

python tools/data/convert_cityscapes.py --cityscapes_path data/cityscapes --num_workers 8
```

（**tips：**如果不创建软连接需要修改configs/_base_/cityscapes.yml中两处dataset_root值为数据集路径。）

### 模型训练

```
export HIP_VISIBLE_DEVICES=0,1,2,3
export HSA_FORCE_FINE_GRAIN_PCIE=1
export HIP_UPSAMPLE_OPTIMIZE=1

python -m paddle.distributed.launch tools/train.py --config configs/unet/unet_cityscapes_1024x512_160k.yml --do_eval --use_vdl --save_interval 176 --save_dir /data/unetouput --log_iters 1 --log_dir /data/pid.txt 2>&1 | tee unet_dcu_`date +%Y%m%d%H%M%S`.log
```



## 准确率数据

| 卡数 | 准确率 |
| :--: | :----: |
|  4   | 63.92% |



## 源码仓库及问题反馈

http://developer.hpccube.com/codes/modelzoo/unet_paddle.git



## 参考

[https://github.com/PaddlePaddle/PaddleSeg/tree/release/2.7/configs/unet(https://github.com/PaddlePaddle/PaddleSeg/tree/release/2.7/configs/unet)