# Unet_Paddle
## 论文
`U-Net: Convolutional Networks for Biomedical Image Segmentation`

- [https://arxiv.org/pdf/1505.04597.pdf](https://arxiv.org/pdf/1505.04597.pdf)
## 模型结构
U-Net模型是一种基于编码器-解码器结构的卷积神经网络，通过不断降采样和上采样的操作，将输入图像映射到相应的分割结果，使得模型具有有效的特征提取和高分辨率分割的能力。

![unet_architecture](unet_architecture.png)


## 算法原理
U-Net模型通过编码器部分进行特征提取，然后通过对称的解码器部分进行特征重建和上采样操作，最终将低分辨率的特征映射转化为高分辨率的分割结果，实现图像分割任务。

![unet](unet.png)


## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/paddlepaddle:2.3.2-centos7.6-dtk-22.10-py38-latest

docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
#进入容器后
pip install opencv-python==3.4.10.35
pip install PyYAML==6.0
pip install sklearn==0.0
pip install filelock==3.9.0
pip install visualdl==2.5.0
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
cd ./docker
docker build --no-cache -t unet_paddle:v1.0 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
#进入容器后
pip install opencv-python==3.4.10.35
pip install PyYAML==6.0
pip install sklearn==0.0
pip install filelock==3.9.0
pip install visualdl==2.5.0
```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk22.10
python：python3.8
paddle:2.3.2
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

之后安装如下三方库

```
pip install opencv-python==3.4.10.35
pip install PyYAML==6.0
pip install sklearn==0.0
pip install filelock==3.9.0
pip install visualdl==2.5.0
```



## 数据集
`cityscapes`
下载地址为:[cityscapes](https://www.cityscapes-dataset.com/)
数据集结构如下：
```
├── cityscapesScripts
│   ├── cityscapesscripts
│   │   ├── annotation
│   │   ├── download
│   │   ├── evaluation
│   │   ├── helpers
│   │   ├── __init__.py
│   │   ├── preparation
│   │   ├── VERSION
│   │   └── viewer
│   ├── docs
│   │   ├── Box3DImageTransform.ipynb
│   │   └── csCalibration.pdf
│   ├── LICENSE
│   ├── README.md
│   ├── setup.cfg
│   └── setup.py
├── gtFine
│   ├── test
│   │   ├── berlin
│   │   ├── bielefeld
│   │   ├── bonn
│   │   ├── leverkusen
│   │   ├── mainz
│   │   └── munich
│   ├── train
│   │   ├── aachen
│   │   ├── bochum
│   │   ├── bremen
│   │   ├── cologne
│   │   ├── darmstadt
│   │   ├── dusseldorf
│   │   ├── erfurt
│   │   ├── hamburg
│   │   ├── hanover
│   │   ├── jena
│   │   ├── krefeld
│   │   ├── monchengladbach
│   │   ├── strasbourg
│   │   ├── stuttgart
│   │   ├── tubingen
│   │   ├── ulm
│   │   ├── weimar
│   │   └── zurich
│   └── val
│       ├── frankfurt
│       ├── lindau
│       └── munster
└── leftImg8bit
    ├── test
    │   ├── berlin
    │   ├── bielefeld
    │   ├── bonn
    │   ├── leverkusen
    │   ├── mainz
    │   └── munich
    ├── train
    │   ├── aachen
    │   ├── bochum
    │   ├── bremen
    │   ├── cologne
    │   ├── darmstadt
    │   ├── dusseldorf
    │   ├── erfurt
    │   ├── hamburg
    │   ├── hanover
    │   ├── jena
    │   ├── krefeld
    │   ├── monchengladbach
    │   ├── strasbourg
    │   ├── stuttgart
    │   ├── tubingen
    │   ├── ulm
    │   ├── weimar
    │   └── zurich
    └── val
        ├── frankfurt
        ├── lindau
        └── munster
```

### 数据预处理：

在PaddleSeg目录下执行

```
pip install -e .
```

修改configs/_base_/cityscapes.yml中两处dataset_root值为数据集路径

![data](data.png)

执行如下指令完成数据的预处理过程

```
pip install cityscapesscripts
python tools/data/convert_cityscapes.py --cityscapes_path data/cityscapes --num_workers 8
```

## 训练
### 单机多卡
```
export HIP_VISIBLE_DEVICES=0,1,2,3
export HSA_FORCE_FINE_GRAIN_PCIE=1
export HIP_UPSAMPLE_OPTIMIZE=1

python -m paddle.distributed.launch tools/train.py --config configs/unet/unet_cityscapes_1024x512_160k.yml --do_eval --use_vdl --save_interval 176 --save_dir /data/unetouput --log_iters 1 --log_dir /data/pid.txt 2>&1 | tee unet_dcu_`date +%Y%m%d%H%M%S`.log
```

## result

![result](result.png)


### 精度
测试数据：something v2，使用的加速卡:Z100L。

根据测试结果情况填写表格：
| 卡数 | 准确率 |
| :------: | :------: |
| 4 | 63.92% |
## 应用场景
### 算法类别
`图像分割`

### 热点应用行业
`医疗,交通,家居`

## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/tsm_pytorch.git
## 参考资料
- https://github.com/open-mmlab/mmaction2
