# Convolutional Networks for Biomedical Image Segmentation(Unet)

## 模型介绍
语义分割(Semantic Segmentation)是图像处理和机器视觉一个重要分支。与分类任务不同，语义分割需要判断图像每个像素点的类别，进行精确分割。语义分割目前在自动驾驶、自动抠图、医疗影像等领域有着比较广泛的应用。其中，Unet模型是最常用、最简单的一种分割模型，它简单、高效、易懂、容易构建、可以从小数据集中训练，具有较好的分割效果。

## 模型结构
Unet模型整体为U型结构，主要分为三部分：下采样、上采样以及跳跃连接。首先，在左半部分进行编码阶段，通过卷积和下采样降低图像尺寸，提取一些浅层特征。其次，在右半部分进行解码阶段，通过卷积和上采样来获取一些深层次的特征。其中卷积采用无填充方式来保证结果都是基于没有缺失上下文特征得到的，因此每次经过卷积后，图像的大小会减小。最后，通过concat的方式，将编码阶段获得的feature map同解码阶段获得的feature map结合在一起，得到更加精细的细节，从而根据feature map进行预测分割。

## Python版本推理

下面介绍如何运行python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

下载MIGraphX镜像： 

```python
docker pull sugonhub/migraphx:3.2.1-centos7.6-dtk-23.04.1-py38
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

```Python
# 进入unet migraphx工程根目录
cd <path_to_unet_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

```python
python Unet.py
```

会在当前目录中生成分割图像

<img src="./Doc/Images/Unet_03.jpg" style="zoom:100%;" align=middle>

## C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

下载MIGraphX镜像： 

```
docker pull sugonhub/migraphx:3.2.1-centos7.6-dtk-23.04.1-py38
```

### 安装Opencv依赖

```python
cd <path_to_unet_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_unet_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

```python
# 进入unet migraphx工程根目录
cd <path_to_unet_migraphx> 

# 进入build目录
cd build/

# 执行示例程序
./Unet
```

会在当前目录中生成分割图像。

<img src="./Doc/Images/Unet_02.jpg" style="zoom:100%;" align=middle>

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/unet_migraphx

## 参考

https://github.com/ROCmSoftwarePlatform/AMDMIGraphX/tree/develop/examples/vision/python_unet

