#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Unet.h>
#include <SimpleLog.h>
#include <Filesystem.h>

int main()
{
    // 加载Unet模型
    migraphxSamples::Unet unet;
    migraphxSamples::InitializationParameterOfSegmentation initParamOfSegmentationUnet;
    initParamOfSegmentationUnet.configFilePath = CONFIG_FILE;
    migraphxSamples::ErrorCode errorCode=unet.Initialize(initParamOfSegmentationUnet);
    if(errorCode!=migraphxSamples::SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize Unet!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize Unet\n");

    // 读取图像
    cv::Mat srcImage =cv::imread("../Resource/Images/car1.jpeg", 1);
   
    // 推理
    cv::Mat maskImage;   
    double time1 = cv::getTickCount();
    unet.Segmentation(srcImage, maskImage);
    double time2 = cv::getTickCount();
    double elapsedTime = (time2 - time1) * 1000 / cv::getTickFrequency();
    LOG_INFO(stdout, "inference time:%f ms\n", elapsedTime);
    LOG_INFO(stdout,"========== Segmentation Results ==========\n");
    LOG_INFO(stdout,"Segmentation results have been saved to ./Result.jpg\n");
    cv::imwrite("./Result.jpg", maskImage);

    return 0;
}