# Convolutional Networks for Biomedical Image Segmentation(U-Net)

## 模型介绍
语义分割(Semantic Segmentation)是图像处理和机器视觉一个重要分支。与分类任务不同，语义分割需要判断图像每个像素点的类别，进行精确分割。语义分割目前在自动驾驶、自动抠图、医疗影像等领域有着比较广泛的应用。其中，Unet模型是最常用、最简单的一种分割模型，它简单、高效、易懂、容易构建、可以从小数据集中训练，具有较好的分割效果。

## 模型结构
U-net模型整体为U型结构，主要分为三部分：下采样、上采样以及跳跃连接。首先，在左半部分进行编码阶段，通过卷积和下采样降低图像尺寸，提取一些浅层特征。其次，在右半部分进行解码阶段，通过卷积和上采样来获取一些深层次的特征。其中卷积采用无填充方式来保证结果都是基于没有缺失上下文特征得到的，因此每次经过卷积后，图像的大小会减小。最后，通过concat的方式，将编码阶段获得的feature map同解码阶段获得的feature map结合在一起，得到更加精细的细节，从而根据feature map进行预测分割。

## Python版本推理

下面介绍如何运行python代码示例，具体推理代码解析，在Doc/Tutorial_Python.md中有详细说明。

### 构建安装

在光源可拉取推理的docker镜像，U-net模型推理的镜像如下： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 推理示例

1.参考《MIGraphX教程》设置好PYTHONPATH

2.安装依赖：

```Python
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入示例程序目录
cd ./Python/

# 安装依赖
pip install -r requirements.txt
```

3.在Python目录下执行如下命令运行该示例程序：

```python
python Unet.py
```

会在当前目录中生成分割图像

<img src="./Doc/Images/Unet_03.jpg" style="zoom:100%;" align=middle>

## C++版本推理

下面介绍如何运行C++代码示例，具体推理代码解析，在Doc/Tutorial_Cpp.md目录中有详细说明。

参考Python版本推理中的构建安装，在光源中拉取推理的docker镜像。

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 推理示例

运行Unet示例程序，具体执行如下命令：

```python
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入build目录
cd ./build/

# 执行示例程序
./Unet
```

会在当前目录中生成分割图像

<img src="./Doc/Images/Unet_02.jpg" style="zoom:100%;" align=middle>

## 历史版本

https://developer.hpccube.com/codes/modelzoo/unet_migraphx

## 参考资料

https://github.com/ROCmSoftwarePlatform/AMDMIGraphX/tree/develop/examples/vision/python_unet

