# Unet

## 论文

U-Net: Convolutional Networks for Biomedical Image Segmentation

- https://arxiv.org/abs/1505.04597

## 模型结构

UNet是一种用于图像分割的卷积神经网络（CNN）架构，该模型整体为U型结构。

<img src="./Doc/Images/Unet_01.png" style="zoom:80%;" align=middle>

## 算法原理
U-Net 的核心原理如下：

1. **编码器（Contracting Path）**：U-Net 的编码器由卷积层和池化层组成，用于捕捉图像的特征信息并逐渐减小分辨率。这一部分的任务是将输入图像缩小到一个低分辨率的特征图，同时保留有关图像内容的关键特征。
2. **中间层（Bottleneck）**：在编码器和解码器之间，U-Net 包括一个中间层，通常由卷积层组成，用于进一步提取特征信息。
3. **解码器（Expansive Path）**：U-Net 的解码器包括上采样层和卷积层，用于将特征图恢复到原始输入图像的分辨率。解码器的任务是将高级特征与低级特征相结合，以便生成分割结果。这一部分的结构与编码器相对称。

<img src="./Doc/Images/Unet_04.png" style="zoom:80%;" align=middle>

## 环境配置

### Docker（方法一）

拉取镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.0.0-centos7.6-dtk23.04.1-py38-latest
```

创建并启动容器：

```
docker run --shm-size 16g --network=host --name=unet_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/unet_migraphx:/home/unet_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t unet_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=unet_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/unet_migraphx:/home/unet_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据提供的样本数据，进行图像分割。

## 推理

### Python版本推理

下面介绍如何运行python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

```Python
# 进入unet migraphx工程根目录
cd <path_to_unet_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

# 运行示例
python Unet.py
```

### C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

#### 安装Opencv依赖

```python
cd <path_to_unet_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```


#### 安装OpenCV并构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_unet_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

```python
# 进入unet migraphx工程根目录
cd <path_to_unet_migraphx> 

# 进入build目录
cd build/

# 执行示例程序
./Unet
```

## result

### Python版本

python程序运行结束后，会在当前目录中生成分割图像。

<img src="./Doc/Images/Unet_03.jpg" style="zoom:100%;" align=middle>

### C++版本

C++程序运行结束后，会在build目录生成分割图像。

<img src="./Doc/Images/Unet_02.jpg" style="zoom:100%;" align=middle>

### 精度

无

## 应用场景

### 算法类别

`图像分割`

### 热点应用行业

`制造`,`交通`,`医疗`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/unet_migraphx

## 参考资料

https://github.com/ROCmSoftwarePlatform/AMDMIGraphX/tree/develop/examples/vision/python_unet

