# Convolutional Networks for Biomedical Image Segmentation(U-Net)

## 模型介绍
语义分割(Semantic Segmentation)是图像处理和机器视觉一个重要分支。与分类任务不同，语义分割需要判断图像每个像素点的类别，进行精确分割。语义分割目前在自动驾驶、自动抠图、医疗影像等领域有着比较广泛的应用。其中，Unet模型是最常用、最简单的一种分割模型，它简单、高效、易懂、容易构建、可以从小数据集中训练，具有较好的分割效果。

## 模型结构
U-net模型整体为U型结构，主要分为三部分：下采样、上采样以及跳跃连接。首先，在左半部分进行编码阶段，通过卷积和下采样降低图像尺寸，提取一些浅层特征。其次，在右半部分进行解码阶段，通过卷积和上采样来获取一些深层次的特征。其中卷积采用无填充方式来保证结果都是基于没有缺失上下文特征得到的，因此每次经过卷积后，图像的大小会减小。最后，通过concat的方式，将编码阶段获得的feature map同解码阶段获得的feature map结合在一起，得到更加精细的细节，从而根据feature map进行预测分割。

## 推理

### 环境配置

在光源可拉取推理的docker镜像，U-Net模型推理的镜像如下： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort_dcu_1.14.0_migraphx2.5.2_dtk22.10.1
```

在光合开发者社区可下载MIGraphX安装包，python依赖安装：

```python
pip install -r requirement.txt
```

### 运行示例

我们提供了基于MIGraphX的推理脚本，版本依赖：

- Migraphx(DCU版本) >= 2.5.2

bert.py是基于Migraphx的推理脚本，使用需安装好MIGraphX。使用方法：

```python
# 执行推理
python unet.py
```

推理结果为：

<img src="./Sample_picture.jpg" style="zoom:90%;" align=middle>

## 历史版本

https://developer.hpccube.com/codes/modelzoo/unet_migraphx

## 参考资料

https://github.com/ROCmSoftwarePlatform/AMDMIGraphX/tree/develop/examples/vision/python_unet

