# UMT5

**注：执行下游任务是需要使用进行预训练, 训练代码参考train_model.py。**
<div align="center">
    <img src="./docs/T5_task.png"/>
</div>

## 论文
- [论文地址] [UniMax: Fairer and more Effective Language Sampling for Large-Scale Multilingual Pretraining](https://arxiv.org/abs/2304.09151)

## 模型结构

umT5：T5 的多语言版本，具备 T5 模型大部分的多功能性，在多语言通用爬虫语料库 mC4 上预训练，覆盖 101 种语言；Encoder-Decoder架构，编码层和解码层都是12层，一共有220M个参数，大概是bert-base 的两倍。

<div align="center">
    <img src="./docs/T5_structure.png"/>
</div>

## 算法原理

总的来说，mT5 跟 T5 一脉相承的，整体基本一样，但在模型结构方面，mT5 用的是 T5.1.1方案，在此对它做个基本的介绍。

它主要的改动来自论文[GLU Variants Improve Transformer](https://arxiv.org/abs/2002.05202)，主要是借用了[Language Modeling with Gated Convolutional Networks](https://arxiv.org/abs/1612.08083) 的**GLU**(Gated Linear Unit)来增强 FFN 部分的效果。具体来说，原来 T5 的 FFN 为（T5 没有 Bias）：

<div align=center>
    <img src="./docs/equation1.png"/>
</div>

改为：

<div align=center>
    <img src="./docs/euqation2.png"/>
</div>

### T5 Transformer
<div align=center>
    <img src="./docs/euqation2.png"/>
</div>

## 环境配置
### Docker（方法一）
[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk24.04.1-py310

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=64G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name umt5 <your imageID> bash

cd /path/your_code_data/umt5

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

### Dockerfile（方法二）
```
cd /path/your_code_data/umt5/docker

docker build --no-cache -t umt5:latest .

docker run --shm-size=64G --name umt5 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v /path/your_code_data/:/path/your_code_data/ -it umt5 bash
```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04.1
python：python3.10
torch:2.1.0
torchvision:0.16.0
deepspeed:0.12.3
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
conda create -n umt5 python=3.10

conda activate umt5 

cd /path/your_code_data/umt5

pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple
```

## 数据集

我们选择大规模中文短文本摘要语料库[LCSTS](http://icrc.hitsz.edu.cn/Article/show/139.html) 作为数据集，该语料基于新浪微博短新闻构建，规模超过 200 万。

数据集快速下载中心：[SCNet datasets](http://113.200.138.88:18080/aidatasets)

项目中的数据集可从快速下载通道下载： [LCSTS](http://113.200.138.88:18080/aidatasets/suolyer/lcsts)

```
├── data
|        ├── data1.tsv
|        ├── data2.tsv
|        ├── data3.tsv

```
## 训练

### 单机多卡
```
python train_multi_dcu.py
```

### 单机单卡
```
python train_single_dcu.py
```



## 推理

### 摘要任务

要进行摘要任务需先进行模型训练，从hf-mirror或者huggingface下载umt5-base模型后，使用**multi_dcu_train.py**进行训练，保存训练权重后，加载权重进行摘要处理。同理，若要处理阅读理解，语言翻译任务时也需要做类似操作。
```
python umt5_summary.py
```

## result

<div align=center>
    <img src="./docs/result.png"/>
</div>

### 精度
测试数据：[LCSTS](http://icrc.hitsz.edu.cn/Article/show/139.html)，使用的加速卡:V100S/K100。

根据测试结果情况填写表格：
| device | Rougue 1 | Rougue 2 |  Rougue L |
| :------: | :------: | :------: | :------: |
| V100s |  26.12 | 14.81 | 23.62 | 
| K100 | 26.94 | 15.38 | 24.24 | 

## 应用场景
### 算法类别
`文本摘要`

### 热点应用行业
`金融,教育,政府,科研,制造,能源,广媒`

## 预训练权重

- [hf-mirror预训练模型下载地址](https://hf-mirror.com/google/umt5-base/tree/main)

- [hf-mirror umt5预训练模型下载地址](https://hf-mirror.com/collections/google/mt5-release-65005f1a520f8d7b4d039509)


预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels)

项目中的预训练权重可从快速下载通道下载： [umt5](http://113.200.138.88:18080/aimodels/umt5)

## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/umt5.git
## 参考资料
- [UniMax: Fairer and more Effective Language Sampling for Large-Scale Multilingual Pretraining](https://arxiv.org/abs/2304.09151)

