import re

def extract_coordinates(input_string):
    # 使用正则表达式提取坐标
    coordinates = re.findall(r"start_box='?\((\d+),(\d+)\)'?", input_string)
    
    # 如果有匹配到坐标，返回第一个匹配项
    if coordinates:
        return tuple(map(int, coordinates[0]))  # 返回坐标的整数值
    return None  # 如果没有找到坐标，返回 None

# # 示例调用
# input_string = 'Thought: 我现在在Preferences窗口中，但看到的是系统资源设置界面。要设置图片为基于调色板的方式，我需要关闭这个窗口，然后找到正确的颜色设置选项。让我先点击"Cancel"按钮关闭这个窗口，然后再寻找正确的颜色设置选项。\nAction: click(start_box=\'(395,810)\')'

# coords = extract_coordinates(input_string)
# print(coords)  # 输出：(395, 810)
