# UI-TARS

## 论文

`UI-TARS:Pioneering Automated GUI Interaction with Native Agents`

* https://arxiv.org/pdf/2501.12326

## 模型结构
该模型基于Qwen-2-VL，并在此基础上继续训练，以获得UI-TARS。

![alt text](readme_imgs/arch.png)

## 算法原理

增强的GUI感知（Enhanced GUI Perception）
UI-TARS通过构建大规模GUI截图和元数据集，训练模型能够更精准地理解界面元素（按钮、文本框等）、它们的布局关系和状态变化。它不仅能识别元素，还能进行细粒度的界面描述、状态转移描述和视觉问答，以增强对复杂GUI环境的感知能力。

统一的动作建模（Unified Action Modeling）
论文提出了一个统一动作空间，把不同平台（Web、桌面、移动端）上等价的操作（如点击、输入、拖拽）统一标准化。并通过大规模多步操作轨迹（multi-step action traces）数据进行训练，使模型能够连贯地完成复杂多步任务。

系统2推理（System-2 Reasoning）
UI-TARS引入了显式的“思考（Thoughts）”机制，在每步操作之前生成推理步骤，进行任务分解、长期一致性维护、里程碑识别、试错反思等多种推理模式。这种设计让UI-TARS不仅能快速反应（System-1），还能有意识地规划和调整（System-2），应对动态变化和复杂任务。

迭代式自我改进（Iterative Training with Reflective Online Traces）
UI-TARS使用数百台虚拟机在线自动采集、筛选并反思自己的交互轨迹。通过不断地数据迭代采集、错误分析、修正训练，模型能够持续学习，适应新环境和任务，极大减少了对人工标注的依赖。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10

    docker run --shm-size 500g --network=host --name=uitars --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install transformers==4.49.0

    pip install opencv-python



### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 500g --network=host --name=uitars --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    
    pip install transformers==4.49.0

    pip install opencv-python

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/

```
dtk: 25.04
python: 3.10
torch: 2.4.1
deepspeed: 0.14.2
flash-attn: 2.6.1
triton: 3.0.0
```

2、其他非特殊库直接按照requirements.txt安装

```
pip install transformers==4.49.0

pip install opencv-python
```

## 数据集

无

## 训练

无

## 推理

```bash
# 运行前需修改文件内参数

# TARS-1.5  推荐
python inference_15.py

# TARS
python inference.py
```

注意：`参考data/test_messages.json`构建自己的数据集，并使用`utils/generate_new_data.py`处理数据。

## result

![alt text](readme_imgs/result1.png)

### 精度

无

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`电商,教育,广媒`

## 预训练权重

下载后的模型放在 `checkpoints` 目录（自行创建）

| Model  | url |
|-----------|------------------|
| UI-TARS-1.5-7B 推荐 | [huggingface](https://huggingface.co/ByteDance-Seed/UI-TARS-1.5-7B)  |
| UI-TARS-2B-SFT | [huggingface](https://huggingface.co/ByteDance-Seed/UI-TARS-2B-SFT)  |
| UI-TARS-7B-SFT | [huggingface](https://huggingface.co/ByteDance-Seed/UI-TARS-7B-SFT)  |
| UI-TARS-7B-DPO | [huggingface](https://huggingface.co/ByteDance-Seed/UI-TARS-7B-DPO)  |
| UI-TARS-72B-SFT| [huggingface](https://huggingface.co/ByteDance-Seed/UI-TARS-72B-SFT)  |
| UI-TARS-72B-DPO| [huggingface](https://huggingface.co/ByteDance-Seed/UI-TARS-72B-DPO)  |


## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/ui-tars_pytorch

## 参考资料

* https://github.com/bytedance/UI-TARS
