# ResNet50_v2
## 论文
`Deep Residual Learning for Image Recognition`
- https://arxiv.org/abs/1512.03385
## 模型结构
ResNet50网络中包含了49个卷积层、1个全连接层等

![image.png](./image.png)
## 算法原理
ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

![image-1.png](./image-1.png)
## 模型文件
  模型文件下载地址： 
```
    "https://github.com/onnx/models/raw/main/vision/classification/resnet/model/resnet50-v2-7.onnx"
```
## 环境配置
### Docker（方法一）

拉取镜像：
```
    docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm-0.11_fp32_cpp_dtk22.10_py38_centos-7.6-latest
```
创建并启动容器
```
docker run --shm-size 16g --network=host --name=ResNet50_v2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/ResNet50_v2_tvm:/home/ResNet50_v2_tvm -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```
## 数据集
  python 推理及调优代码使用的图片数据为：
```
    "https://s3.amazonaws.com/model-server/inputs/kitten.jpg"
``` 
  标签数据为：
```
    "https://s3.amazonaws.com/onnx-model-zoo/synset.txt"
```
   C++部署代码使用数据为：
```
    "https://github.com/ultralytics/yolov5/releases/download/v1.0/coco128.zip"
```
### 推理
  下载模型文件后执行以下命令进行推理测试及调优测试：
```
    python tune_resnet50-v2.py
```
    
    
### 单卡部署推理测试
  下载配置好镜像之后，cd /tvm-0.11-dev0/apps/ 进入该路径下，将代码下载放到该路径下，cd tvm_tune_resnet50-v2/ 进入该路径后，
执行以下命令：
```
    mkdir -p lib
    python prepare_test_libs.py
    sh run_example.sh
```
## 精度
```
    max_num:15.6692
    max_iter:0x28cda14
    max_num_index:345
``` 
## 应用场景

### 算法类别

图像分类

### 热点应用行业

制造,政府,医疗,科研
    
## 源码仓库及问题反馈

   * https://developer.hpccube.com/codes/modelzoo/tvm_tune_resnet50-v2

## 参考

   * [https://tvm.apache.org/docs/how_to/tune_with_autoscheduler/tune_network_cuda.html]()

