# ResNet50
## 论文
`Deep Residual Learning for Image Recognition`
- https://arxiv.org/abs/1512.03385

## 模型结构
ResNet50网络中包含了49个卷积层、1个全连接层等

![image.png](./image.png)

## 算法原理
ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

![image-1.png](./image-1.png)

## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm-0.11_fp32_cpp_dtk22.10_py38_centos-7.6-latest
docker run --shm-size 16g --network=host --name=ResNet50_v2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集
python推理及调优代码使用的图片数据为：[kitten](./kitten.jpg)

标签数据为：[synset.txt](./synset.txt)

C++部署代码使用数据为：[coco128](./coco128.zip)

coco128数据集的目录结构如下：
```
├── images
│   ├── train2017
├── labels
│   ├── train2017
├── LICENSE
├── README.txt
```

## 推理
下载模型文件[resnet50-v2-7.onnx](https://github.com/onnx/models/blob/main/validated/vision/classification/resnet/model/resnet50-v2-7.onnx)，执行以下命令进行推理测试及调优测试：
```bash
git clone http://developer.sourcefind.cn/codes/modelzoo/tvm_tune_resnet50-v2.git
cd tvm_tune_resnet50-v2
export HIP_VISIBLE_DEVICES=1 #此处为指定哪张加速卡进行推理的ID号
python tune_resnet50-v2.py   #根据实际修改模型路径
```

### 单卡部署推理测试
下载配置好镜像之后，执行以下命令：
```bash
# 进入该路径下
cd /tvm-0.11-dev0/apps/ # 将代码下载放到该路径下
# 进入
cd tvm_tune_resnet50-v2/
# 执行
mkdir -p lib
export HIP_VISIBLE_DEVICES=1 #此处为指定哪张加速卡进行推理的ID号
python prepare_test_libs.py  #根据实际修改模型路径
sh run_example.sh
```

## result
![kitten-1.jpg](./kitten-1.jpg)

### 精度
| max_num | max_iter | max_num_index |
| :------: | :------: | :------: |
| 15.6692 | 0x28cda14 | 345 |

## 应用场景
### 算法类别
图像分类

### 热点应用行业
制造,政府,医疗,科研

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/tvm_tune_resnet50-v2

### 参考资料
- https://tvm.apache.org/docs
