# TVM 
## 模型介绍
```
   ResNet-50v2是ResNet系列中的一个经典模型，由50层卷积层、批量归一化、激活函数和池化层构成。它引入了一种全新的残差块结构，
即bottleneck结构，使得网络参数量大幅度降低，同时精度也有所提升，ResNet-50v2适用于各种图像分类任务。本示例为使用TVM对训练
好的ResNet-50v2 onnx格式的模型文件，进行推理调优及部署的流程。
```
## 模型结构
```
    ResNet50-v2
```
## 数据集及模型文件
  模型文件下载地址： 
```
    "https://github.com/onnx/models/raw/main/vision/classification/resnet/model/resnet50-v2-7.onnx"
```
    

## 推理、自动调优及部署
###  环境配置
  拉取镜像：
```
    docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm-0.11_fp32_cpp_dtk22.10_py38_centos-7.6-latest
```

###  执行推理及调优
  下载模型文件后执行以下命令进行推理测试及调优测试：
```
    python tune_resnet50-v2.py
```
    
    
### 单卡部署推理测试
  下载配置好镜像之后，cd /tvm-0.11-dev0/apps/ 进入该路径下，执行git clone https://developer.hpccube.com/codes/modelzoo/tvm_tune_resnet50-v2.git 下载代码，
cd tvm_tune_resnet50-v2/ 进入该路径后，执行以下命令：
```
    mkdir -p lib
    python prepare_test_libs.py
    sh run_example.sh
```
## 准确率数据
```
    max_num:15.6692
    max_iter:0x28cda14
    max_num_index:345
```
## TVM版本
```
    TVM-0.11
```   
    

## 源码仓库及问题反馈

   * https://developer.hpccube.com/codes/modelzoo/tvm_tune_resnet50-v2

## 参考

   * [https://tvm.apache.org/docs/how_to/tune_with_autoscheduler/tune_network_cuda.html#sphx-glr-how-to-tune-with-autoscheduler-tune-network-cuda-py]()

