# TSM_PyTorch算力测试

## 1.模型介绍

TSM（Temporal Shift Module）是一种用于视频分类的模型，它使用时间平移操作将视频中的不同时间段进行分离，然后使用二维卷积神经网络对这些时间段进行分类。TSM模型采用了时间平移和空间卷积两种模块来实现视频分类。

在时间平移模块中，TSM模型通过将视频的每个时间片段进行平移来实现时间分离。这样，每个时间片段都可以被独立地处理。平移操作通过将视频分成多个时间段，并对这些时间段进行随机平移和拼接而实现。

在空间卷积模块中，TSM模型使用了二维卷积神经网络对每个时间片段进行分类。这样，模型可以学习到每个时间片段中的空间特征，并将这些特征用于分类。

TSM模型在视频分类任务上取得了很好的效果，特别是在大规模视频数据集上。

## 2.模型结构

TSM（Temporal Shift Module）模型结构主要由时间平移模块和二维卷积神经网络组成。

时间平移模块使用时间平移操作将视频中的不同时间段进行分离。具体来说，时间平移模块将视频的每个时间片段划分为多个组，然后对每个组进行随机平移和拼接，以实现时间分离。这样，每个时间片段都可以被独立地处理，从而提高了模型的效率和准确率。

二维卷积神经网络用于对每个时间片段进行分类。具体来说，TSM模型使用了一系列的卷积层、池化层和批归一化层来提取每个时间片段中的空间特征，并将这些特征用于分类。TSM模型中的卷积层通常采用3x3或5x5大小的卷积核，以捕捉不同尺度的空间特征。此外，TSM模型还使用了残差连接和注意力机制等技术来提高模型的效率和准确率。

总体来说，TSM模型结构是一个深度卷积神经网络，它使用时间平移操作将视频中的不同时间段进行分离，并使用二维卷积神经网络对每个时间片段进行分类。这种结构能够有效地提高模型的效率和准确率，在大规模视频分类任务中取得了很好的效果。



## 3.数据集

使用Something-Something V2数据集，Something-Something V2是一个大规模的视频动作识别数据集，由纽约大学、谷歌、MIT等机构联合发布。该数据集包含220,847个视频剪辑，每个视频剪辑由一系列手势动作组成，这些手势动作可以是简单的动作，例如“拍手”、“摆手”等，也可以是复杂的动作，例如“穿衣服”、“打扫卫生”等。每个动作剪辑的平均长度为2.75秒，总时长为600小时，这些视频剪辑都是在真实场景下拍摄的，包括不同的光照、背景和物体等。

Something-Something V2数据集是一个挑战性的数据集，需要模型具备对复杂场景下的手势动作进行准确分类的能力。该数据集可以用于视频动作识别、行为分析、视频检索等任务的研究和评估。

## 4.训练

### 环境配置

提供光源拉取的训练镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py38-latest
```

### 数据预处理

在/workspace/mmaction2目录下创建data子目录，进入data目录，创建软链接指向数据集实际路径：

```
ln -s /dataset/ sthv2
```

使用如下指令进行解压

```
cat 20bn-something-something-v2-?? | tar zx
```

解压完成后使用如下命令抽取RGB帧

```
bash extract_rgb_frames_opencv.sh
```



## 准确率数据

| 卡数 | 准确率 |
| :--: | :----: |
|  4   | 59.14% |



## 源码仓库及问题反馈

http://developer.hpccube.com/codes/modelzoo/tsm_pytorch.git



## 参考

https://github.com/open-mmlab/mmaction2

https://download.openmmlab.com/mmaction/recognition/tsm/tsm_r50_1x1x8_50e_sthv2_rgb/20210816_224310.log
