# TSM
## 论文
`TSM: Temporal Shift Module for Efficient Video Understanding`
- https://openaccess.thecvf.com/content_ICCV_2019/html/Lin_TSM_Temporal_Shift_Module_for_Efficient_Video_Understanding_ICCV_2019_paper.html

## 模型结构
TSM模型的结构由一个时间偏移模块和一个分类器组成，其中时间偏移模块通过将输入的视频特征序列进行平移来利用不同时间偏移版本的信息，而分类器则用于对经过时间偏移的特征进行分类。

![TSM_model](TSM_model.png)

## 算法原理
TSM模型通过在时间维度上应用偏移操作，将输入的视频特征序列进行平移，从而利用时间信息的不同偏移版本来增强模型对视频动态变化的感知能力。

![TSM_model2](TSM_model2.png)

## 环境配置
### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py38-latest

docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t tsm:1.0 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```
### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk22.10
python：python3.8
torch：1.10
torchvision：0.10
mmcv-full：1.6.1+gitdebbc80.dtk2210
```
`Tips：以上dtk驱动、python、pytorch、mmcv等DCU相关工具版本需要严格一一对应`

之后还需要对部分版本进行限制

```
pip3 install yapf==0.32.0
```

## 数据集
`Kinetics400`
- https://drive.google.com/drive/folders/1OVDtdqNnOrzZ6PfoWMUNrsqvPijWHMCD

数据预处理步骤：

1. 进入工程目录后，创建data子目录，进入data目录，创建软链接指向数据集实际路径：
```
cd tsm_pytorch
mkdir data
cd data
ln -s /dataset/ sthv2
```

2. 使用如下指令进行解压
```
cat 20bn-something-something-v2-?? | tar zx
```

3. 将解压之后得到的20bn-something-something-v2文件夹重命名为videos

4. 解压完成后使用如下命令抽取RGB帧

```bash
cd /workspace/tools/data/sthv2/
bash extract_rgb_frames_opencv.sh
```

5. 抽帧结束后，在sthv2里面创建annotations目录，将标注文件（something-something-v2-labels.json、something-something-v2-test.json、something-something-v2-train.json、something-something-v2-validation.json）移动到annotations子目录中

```bash
cd /workspace/tools/data/sthv2/
bash generate_rawframes_filelist.sh
```

预处理之后，目录结构如下：

```
├── 20bn-something-something-v2-00
├── 20bn-something-something-v2-01
├── 20bn-something-something-v2-02
├── 20bn-something-something-v2-03
├── 20bn-something-something-v2-04
├── 20bn-something-something-v2-05
├── 20bn-something-something-v2-06
├── 20bn-something-something-v2-07
├── 20bn-something-something-v2-08
├── 20bn-something-something-v2-09
├── 20bn-something-something-v2-10
├── 20bn-something-something-v2-11
├── 20bn-something-something-v2-12
├── 20bn-something-something-v2-13
├── 20bn-something-something-v2-14
├── 20bn-something-something-v2-15
├── 20bn-something-something-v2-16
├── 20bn-something-something-v2-17
├── 20bn-something-something-v2-18
├── 20bn-something-something-v2-19
├── annotations
├── rawframes
├── sthv2_train_list_rawframes.txt
├── sthv2_val_list_rawframes.txt
└── videos
```

## 训练
### 单机多卡
```
bash train.sh
```

### 单机单卡
```
bash train_single.sh
```

## result
测试的日志会以tsm_dcu_date.log的形式保存在工程的根目录中

<figure>
<img src="result_1.png" width=350/>
<img src="result_2.png" width=350/>
<img src="result_3.png" width=350/>
<img src="result_4.png" width=350/>
</figure>

### 精度
测试数据：something v2，使用的加速卡:Z100L。

根据测试结果情况填写表格：
| 卡数 | 准确率 |
| :------: | :------: |
| 4 | 59.14% |

## 应用场景
### 算法类别
动作识别

### 热点应用行业
交通,政府,家居

## 预训练权重
[r50_8xb16-1x1x8-50e_kinetics400](https://download.openmmlab.com/mmaction/v1.0/recognition/tsm/tsm_imagenet-pretrained-r50_8xb16-1x1x8-50e_kinetics400-rgb/tsm_imagenet-pretrained-r50_8xb16-1x1x8-50e_kinetics400-rgb_20220831-64d69186.pth)

## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/tsm_pytorch.git

## 参考资料
- https://github.com/open-mmlab/mmaction2
