#!/usr/bin/env bash
export HIP_VISIBLE_DEVICES=0,1,2,3

PID_FILE=$2
echo $$ > $PID_FILE
CUR_DIR="$( cd "$(dirname "$0")" ; pwd )"
cd $CUR_DIR

# Dataset prepare
start=$(date +%s)
start_str=`date '+%Y-%m-%d %H:%M:%S' -d "@$start"`
echo "$start_str Begin dataset prepare"

if [ ! -d "data" ]; then
  mkdir data
fi
cd $CUR_DIR/data
ln -s /jiutiandata/7.4/ sthv2
cd $CUR_DIR/data/sthv2
cat 20bn-something-something-v2-?? | tar zx
mv 20bn-something-something-v2 videos
cd $CUR_DIR/tools/data/sthv2
bash extract_rgb_frames_opencv.sh
bash generate_rawframes_filelist.sh

end=$(date +%s)
end_str=`date '+%Y-%m-%d %H:%M:%S' -d "@$end"`
echo "$end_str Finish dataset prepare"
data_prepare_time=$(($end-$start))
echo "Dataset prepare time: ${data_prepare_time}s"

# running training
cd $CUR_DIR
./tools/dist_train.sh configs/recognition/tsm/tsm_r50_1x1x8_50e_sthv2_rgb.py 4 --validate --seed 0 --cfg-options model.backbone.pretrained=/jiutiandata/7.4/resnet50_8xb32_in1k_20210831-ea4938fc.pth optimizer.lr=0.005 data.videos_per_gpu=8 data.val_dataloader.videos_per_gpu=16 data.test_dataloader.videos_per_gpu=3 data.workers_per_gpu=4 evaluation.interval=1 $1 $2
