# 算法名简写（英文简写大写）
## 论文
`Transformer-XL: Attentive Language Models Beyond a Fixed-Length Context`

- https://arxiv.org/abs/1901.02860
## 模型结构
 TransformersXL 是一种改进的 Transformer 模型，旨在处理更长的文本序列。它引入了**延展性机制**，通过**分块处理**超长序列，然后使用**跨块注意力**来捕捉长距离依赖关系。 

![img](doc\模型结构.png)
## 算法原理
 Transformer-XL 在很大程度上依赖于普通 Transformer（Al-Rfou 等人），但引入了两种创新技术——**递归机制**和**相对位置编码**——来克服普通 Transformer 的缺点以下是其原理对比

transformer

![](doc\transformer的训练与评估.png)

transformer-XL

![img](doc\xl的训练与评估.png)
## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py37-latest

docker run -it --network=host --name=transformer-XL --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=32G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 -v /root/transformerxl:/home image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py37-latest
```
### Anaconda（方法二）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk22.10
python：python3.7
```
`Tips：以上dtk驱动、python等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：
```
pip install -r requirements.txt
```
## 数据集
`enwik8`

- http://mattmahoney.net/dc/enwik8.zip

此处提供数据预处理脚本的使用方法
```
wget https://raw.githubusercontent.com/salesforce/awd-lstm-lm/master/data/enwik8/prep_enwik8.py

python3 prep_enwik8.py
```
项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
 ── data
    │   ├── train.txt
    │   └── vaild.txt
    │   └── test.txt   
```
## 训练
### 单机多卡
```
sh run_enwik8_base_dp.sh train
```

### 单机单卡
```
sh run_enwik8_base.sh train
```
## 推理
```
sh run_enwik8_base.sh eval --work_dir 模型路径
```
## result
![rusult](doc\rusult.png)

### 精度
测试数据：[test data](http://mattmahoney.net/dc/enwik8.zip)，使用的加速卡:Z100L。

根据测试结果情况填写表格：
| transformer-XL | loss | bpc |
| :------: | :------: | :------: |
| enwik8 | 0.9 | 1.292 |
## 应用场景
### 算法类别

`nlp、长序列处理`

### 热点应用行业
`自然语言生成`、`机器翻译`、`长文本分类`、`对话系统`

## 源码仓库及问题反馈
- 此处填本项目gitlab地址
## 参考资料
- https://github.com/kimiyoung/transformer-xl
