# ToolACE

## 论文

`ToolACE: Winning the Points of LLM Function Calling`

* https://arxiv.org/pdf/2409.00920


## 模型结构

模型LLama3.1训练

![alt text](readme_imgs/arch.png)

## 算法原理
Multi-Head Attention是一种并行注意力机制，它通过多个子空间中的注意力头协同工作，从不同角度捕捉序列中元素之间的关系，从而增强模型的表达能力。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10

    docker run --shm-size 100g --network=host --name=toolace --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -U transformers
    pip install accelerate


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 100g --network=host --name=toolace --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    
    pip install -U transformers
    pip install accelerate

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/

```
DTK驱动:dtk25.04
python:python3.10
torch:2.4.1
triton:3.0
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
```

2、其他非特殊库直接按照requirements.txt安装

```
pip install -U transformers
pip install accelerate
```

## 数据集

[ToolACE](https://huggingface.co/datasets/Team-ACE/ToolACE)

本项目提供适用于`llama-factory`的数据格式，位于`datasets/data_1.json`


## 训练

### 安装llama-factory

详情参考[llama-factory](https://developer.sourcefind.cn/codes/OpenDAS/llama-factory/-/tree/0.9.2-parallel_tool).

### Lora

```bash
llamafactory-cli train examples/train_lora/llama3_lora_sft_ds3.yaml
```

在运行前需要修改`examples/train_lora/llama3_lora_sft_ds3.yaml`中相应参数。


## 推理

```bash
python inference.py
```

## result

```python
[sales_growth.calculate(company="XYZ", years=3), financial_ratios interest_coverage(company_name="XYZ", years=3)]
```

注意：结果可能根据参数不同而变化。

### 精度
训练配置：见训练部分，llama-factory默认参数。

数据：本项目提供的数据集。

Loss
|K100AI|L20|
|:---:|:---:|
|0.3|0.3|

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`电商,教育,广媒`

## 预训练权重

[ToolACE-2-Llama-3.1-8B](https://hf-mirror.com/Team-ACE/ToolACE-2-Llama-3.1-8B)

## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/toolace_pytorch

## 参考资料

* https://hf-mirror.com/Team-ACE/ToolACE-2-Llama-3.1-8B
