# TimeGPT-1
## 论文
[TimeGPT-1](https://arxiv.org/abs/2310.03589)


## 模型简介
TimeGPT 是一个基于 Transformer 的时间序列模型，能够为训练过程中看不到的各种数据集生成准确的预测。

![alt text](image-1.png)

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.1 |
| python | 3.11 |
| torch | 2.4.1+das.opt1.dtk25041 |


推荐使用镜像:
- 挂载地址 `-v` 根据实际模型情况修改

```bash
docker run -it --shm-size 50g --network=host --name timegpt --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.11 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
暂无

## 训练
暂无
<!-- ### 单机训练
```bash

``` -->

<!-- ### 多机训练
```bash

``` -->

## 推理

### 单机推理
```bash
# Get your API Key at dashboard.nixtla.io
# 初始化
nixtla_client = NixtlaClient(api_key = 'YOUR API KEY HERE')
# 以电力数据为例
df = pd.read_csv('https://raw.githubusercontent.com/Nixtla/transfer-learning-time-series/main/datasets/electricity-short.csv')
# 预测
fcst_df = nixtla_client.forecast(df, h=24, level=[80, 90])

```

<!-- ### 多机推理
```bash

``` -->


### 精度
DCU与GPU精度一致

## 预训练权重
<!-- | 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
|  | - | K100AI | 1 | [下载地址]() | -->
暂无


## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/timegpt-pytorch

## 参考资料
- https://github.com/Nixtla/nixtla
