# 仓库目录结构
* 除预训练模型外其他文件总大小尽量不要超过50M
```
    Project
    ├── dataset
    │   ├── filename_1
    │             ├── xxx.png
    │             ├── xxx.png
    │             └── ...
    │   └── filename_2
    │             ├── xxx.png
    │             ├── xxx.png
    │             └── ...
    ├── doc
    │   ├── icon.png
    │   ├── xxx.png
    │   └── xxx.png
    ├── README.md
    ├── requirement.txt
    ├── model.properties
    ├── code_file1.py
    ├── code_file2.py
    ├── code_file3.py
    ├── dirs
    │   ├── code_file4.py
    │   ├── code_file5.py
    └── └── code_file6.py
```

* icon.png：模型的图标文件，上传者需放至项目根目录供前端读取，所需算法类别图标可到 [飞书->云文档->云盘->icon](https://r0ddbu55vzx.feishu.cn/drive/folder/AgoUfBk5IlYTV1dBz2YcGSYUnDf) 查找，放入仓库后的图标文件，需要将名称从`类别名称`修改为`icon`，如`OCR.png`修改为`icon.png`。
![icon](./icon.png)

* README.md：参照下图。
![img](./doc/readme.png)

* requirement.txt：模型依赖统一写到此文件，与NV相关的库请注释，以免安装错误。
```
说明：数据基本由公司网盘储存并提供url下载或直接读取，数据信息介绍由超算互联网商城提供，内部无数据时提供官网下载地址。
```
* 需要提供迷你数据集以供使用者快速上手项目。

* model.properties：`五大属性`固定模板如下：
```
    # 模型唯一标识
    modelCode=Project ID
    # 模型名称
    modelName=模型名称(同项目名称：模型名_深度学习框架，小写)
    # 模型描述
    modelDescription=简要描述此模型(尽量50字以内)
    # 应用场景
    processType=推理,训练
    # 算法类别
    appScenario=代码生成
    # 框架类型
    frameType=pytorch(说明使用的算法框架, 多个标签用英文逗号隔开。)
    # 加速卡类型
    accelerateType=BW1000,K100AI(设备为项目中所运行模型测试所用的加速卡，以帮助用户在光源可快速进行目标选型。)
```

* 增加LICENSE（必要），源github无LICENSE则在LICENSE里填：None LICENSE Currently；CONTRIBUTORS.md根据源github有无提供（非必要）。