# TeleAI_T1
## 论文
暂无

## 模型简介
T1 模型是 TeleChat 系列专注于复杂推理的模型，由中国电信人工智能研究院基于国产算力研发训练。该系列模型借助先进的思维推理和批判纠错能力，在下游复杂任务中有很好的表现。本次我们开源了 T1-35B 和 T1-115B 两款不同尺寸的模型，与同尺寸模型相比都具有较好的效果表现。

**训练策略**
采用课程学习贯穿全流程的后训练方案，循序渐进提升模型效果。

**微调阶段：** 将多任务数据集进行难度划分（根据模型推理正误比率判断），首先使用中低难度冷启动微调，然后使用RFT方式筛选中高难度数据进行持续微调进行效果提升；
**强化学习阶段：** 首先对数理逻辑、代码能力进行提升，采用难度渐进式课程学习方案进行能力强化；然后，基于指令遵循、安全、幻觉、Function Call等10多种混合通用任务进行持续强化，全面提升模型效果；

<div align=center>
    <img src="./doc/model_eval.png"/>
</div>



## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

推荐使用镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name teleai-t1 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
```bash
## serve启动
## 可参考vllm_serve.sh脚本
vllm serve /path/of/TeleAI/T1-35B/ \
    --trust-remote-code \
    --max-model-len 32768 \
    --served-model-name teleai_t1 \
    --dtype bfloat16 \
    -tp 4

## client访问
可参考vllm_cilent.sh
curl http://localhost:8000/v1/chat/completions     -H "Content-Type: application/json"     -d '{
        "model": "teleai_t1",
        "messages": [
            {
                "role": "user",
                "content": "介绍一下你自己"
            }
        ],
        "chat_template_kwargs": {
            "thinking": true
        }
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| TeleAI_T1 | 35B | BW1000 | 4 | [modelscope](https://modelscope.cn/models/TeleAI/T1-35B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/teleai_t1_vllm

## 参考资料
- https://github.com/Tele-AI/T1/tree/main
