# Swin Transformer 

## 模型介绍
Swin Transformer可以作为计算机视觉的通用支柱。将 Transformer 从语言转换为视觉的挑战来自于两个域之间的差异，例如视觉实体的尺度差异大，以及图像中像素相对于文本中单词的高分辨率。为了解决这些差异，提出了一个分层( hierarchical )Transformer，其表示是用移动窗口( Shifted windows )计算的。移动窗口方案通过将自注意力计算限制到非重叠的局部窗口，同时允许跨窗口连接，从而带来更高的效率。这种分层体系结构具有在各种尺度上建模的灵活性，并且具有与图像大小相关的线性计算复杂度。Swin Trans former 的这些特性使其可以兼容广泛的视觉任务，包括图像分类( ImageNet - 1K的top - 1准确率为87.3 %)和密集预测任务，如目标检测( 在COCO test-dev上实现了58.7 box AP和51.1 mask AP )和语义分割( 53.5 mIoU )。2021年，其性能在COCO上以 + 2.7 box AP 和 + 2.6 mask AP 的大幅优势超越了先前的先进水平，在ADE20K上以+ 3.2 mIoU的优势超越了先前的先进水平，显示了基于 Transformer 的模型作为视觉中枢的潜力。分层设计和移位窗口方法也被证明对 full-MLP 体系结构有利。

## 模型结构
Swin Transformer体系结构的概述如下图所示，其中说明了 tiny version ( Swin-T )。它首先通过 patch 分割模块(如ViT )将输入的RGB图像分割成不重叠的 patch 。每个 patch 被当作一个 "token" ( 相当于NLP中的词源 )处理，它的特征被设置为原始像素RGB值的 concatenation。在我们的实现中，我们使用了 4 × 4 的 patch 大小，因此每个 patch 的特征维度为 4 × 4 × 3 = 48。在这个原始值特征上应用一个线性嵌入层，将其投影到任意维度( 记为C )。Swin Transformer block将Transformer块中的标准多头自注意力( MSA )模块替换为基于移动窗口的模块，其他层保持不变。如图( b )所示，一个 SwinTransformer 模块由一个基于移动窗口的MSA模块组成，其后是一个2层的MLP，GELU非线性介于两者之间。在每个MSA模块和每个MLP之前施加一个 LayerNorm ( LN )层，在每个模块之后施加一个残差连接。

![img](./docs/cc163380115640d4a5d88ffb246bde44.png)

- ( a )Swin Transformer ( Swin-T )的结构；
- ( b )连续 2 个Swin Transformer 块。

## 数据集

在本测试中可以使用tiny-imagenet-200数据集。

数据集处理方法请参考imagenet官方介绍自行处理，也可通过下面链接下载使用。

链接：链接：https://pan.baidu.com/s/17dg8g5VhMfU5_9SUogMP7w?pwd=fy0p 提取码：fy0p 

## Swin-Transformer训练
### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练以及推理的docker镜像：
* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt

### 训练
训练命令：

    export HIP_VISIBLE_DEVICES=0
    
    python3 -m torch.distributed.launch --nproc_per_node 1 --master_port 12345  main.py --cfg configs/swin/swin_tiny_patch4_window7_224.yaml --data-path /code/Datasets/tiny-imagenet-200/ --batch-size 128 --disable_amp

## 性能和准确率数据
测试数据使用的是tiny-imagenet-200，使用的加速卡是DCU Z100L。

| 卡数 | 性能 | 精度 |
| :------: | :------: | :------: |
| 1 | 127.237 samples/s | Acc@1：63.416  Acc：@5 85.666 |
### 参考

https://github.com/microsoft/Swin-Transformer