# Step1X-Edit

## 论文
`
Step1X-Edit: A Practical Framework for General Image Editing
`
- https://arxiv.org/abs/2504.17761

## 模型结构
Step1X-Edit通过结合多模态大语言模型（MLLM）和扩散图像解码器来处理参考图像和用户的编辑指令，提取潜在嵌入以获得目标图像。
<div align=center>
    <img src="./assets/frame_work.png"/>
</div>

## 算法原理

Step1X-Edit的核心在于结合多模态大语言模型（MLLM）和扩散Transformer（DiT）架构。 具体来说：

- 输入的编辑指令和参考图像首先由MLLM（如Qwen-VL）处理，生成与编辑任务直接对齐的令牌嵌入。

- 提取的嵌入随后被输入到一个轻量级的连接模块（如令牌细化器），重新结构化为更紧凑的文本特征表示。

- 进一步，通过计算Qwen所有输出嵌入的平均值并将其投影到线性层，生成全局视觉引导向量，以增强模型的语义理解能力。

- 在训练过程中，采用联合学习设置，同时优化连接模块和下游DiT，初始权重来自预训练的Qwen和DiT文本到图像模型。


## 环境配置

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10
# <your IMAGE ID>为以上拉取的docker的镜像ID替换
docker run -it --shm-size=64G -v $PWD/Step1X-Edit_pytorch:/home/Step1X-Edit_pytorch -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name step1x_edit <your IMAGE ID> bash
cd /home/Step1X-Edit_pytorch
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
wget --content-disposition 'https://download.sourcefind.cn:65024/directlink/4/triton/DAS1.3/triton-2.1.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl'
pip install triton-2.1.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl
```
### Dockerfile（方法二）
```
cd /home/Step1X-Edit_pytorch/docker
docker build --no-cache -t step1x_edit:latest .
docker run --shm-size=64G --name step1x_edit -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/Step1X-Edit_pytorch:/home/Step1X-Edit_pytorch -it step1x_edit bash
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
wget --content-disposition 'https://download.sourcefind.cn:65024/directlink/4/triton/DAS1.3/triton-2.1.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl'
pip install triton-2.1.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.3
python:python3.10
torch:2.3.0
torchvision:0.18.1
triton:2.1.0
flash-attn:2.6.1

```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/Step1X-Edit_pytorch
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
wget --content-disposition 'https://download.sourcefind.cn:65024/directlink/4/triton/DAS1.3/triton-2.1.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl'
pip install triton-2.1.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl
```

## 数据集
`无`

## 训练
`无`

## 推理
预训练权重目录结构：
```
/home/Step1X-Edit_pytorch
    └── Qwen/Qwen2.5-VL-7B-Instruct
    └── meimeilook/Step1X-Edit-FP8
``` 

### 单机单卡
```
bash scripts/run_examples.sh
```

更多资料可参考源项目中的[`README_orgin`](./README_orgin.md)。

## result
图像编辑效果示例：

输入:

- `prompt:给这个女生的脖子上戴一个带有红宝石的吊坠。 `

<div align=center>
    <img src="./examples/0000.jpg"/>
</div>

- `prompt:让她哭。 `

<div align=center>
    <img src="./examples/0001.png"/>
</div>



输出:

<div align=center>
    <img src="./assets/0000.jpg"/>
</div>

<div align=center>
    <img src="./assets/0001.png"/>
</div>

### 精度
`无`

## 应用场景
### 算法类别
`多模态`
### 热点应用行业
`绘画,动漫,媒体,制造,广媒,家居,教育`
## 预训练权重
huggingface权重下载地址为：

- [meimeilook/Step1X-Edit-FP8](https://huggingface.co/meimeilook/Step1X-Edit-FP8)

- [Qwen/Qwen2.5-VL-7B-Instruct](https://huggingface.co/Qwen/Qwen2.5-VL-7B-Instruct)

`注：建议加镜像源下载：export HF_ENDPOINT=https://hf-mirror.com`
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/Step1X-Edit_pytorch.git
## 参考资料
- https://github.com/stepfun-ai/Step1X-Edit

