# Step-Video-T2V

## 论文
`
Step-Video-T2V Technical Report: The Practice, Challenges, and Future of Video Foundation Model
`
- https://arxiv.org/abs/2502.10248

## 模型结构
Step-Video-T2V的整体架构如下图所示。这是一个最先进的文本到视频预训练模型，拥有300亿个参数，能够生成最长204帧的视频。

<div align=center>
    <img src="./assets/model_architecture.png"/>
</div>

## 算法原理

Step-Video-T2 V是一种使用流匹配训练的基于扩散Transformer（DiT）的模型。具体设计如下：
- 一个深度压缩变分自动编码器，Video-VAE，专为视频生成任务而设计，实现了16x16的空间压缩比和8x的时间压缩比，同时保持了卓越的视频重建质量。
- 用户提示使用两个双语文本编码器进行编码，以处理英语和中文。 使用流匹配训练具有3D全注意力机制的DiT，并用于将输入噪声去噪为潜在帧。 
- 应用基于视频的DPO方法，Video-DPO，以减少伪影并提高生成视频的视觉质量。



## 环境配置

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy
# <your IMAGE ID>为以上拉取的docker的镜像ID替换
docker run -it --name T2V_test --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v $PWD/Step-Video-TI2V_pytorch:/home/Step-Video-T2V_pytorch <your IMAGE ID> /bin/bash
cd /home/Step-Video-T2V_pytorch
pip install -e . -i https://mirrors.aliyun.com/pypi/simple/
pip uninstall asyncio
sh fix.sh

```
### Dockerfile（方法二）
```
cd /home/Step-Video-T2V_pytorch/docker
docker build --no-cache -t Step-Video-TI2V:latest .
docker run -it --name T2V_test --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v $PWD/Step-Video-T2V_pytorch:/home/Step-Video-TI2V_pytorch Step-Video-T2V /bin/bash
pip install -e . -i https://mirrors.aliyun.com/pypi/simple/
pip uninstall asyncio
sh fix.sh
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk25.04
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
flash-attn:2.6.1

```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/Step-Video-T2V_pytorch
pip install -e . -i https://mirrors.aliyun.com/pypi/simple
pip uninstall asyncio
sh fix.sh
```

## 数据集
`无`

## 训练
`无`

## 推理
预训练权重目录结构：
```
/home/Step-Video-T2V_pytorch
    └── stepfun-ai/stepvideo-t2v
``` 

### 单机多卡
```
#根据自己的DCU架构调整TORCH_CUDA_ARCH_LIST值
export TORCH_CUDA_ARCH_LIST="8.0"
#注意修改where_you_download_dir为自己的模型地址
HIP_VISIBLE_DEVICES=0 python api/call_remote_server.py --model_dir where_you_download_dir &
#注意为了避免超显存服务端和客户端尽量选择不同的卡号,run.sh里的其他参数也可根据自己的硬件资源自行调整
export HIP_VISIBLE_DEVICES=1,2
sh run.sh
```

更多资料可参考源项目中的[`README_orgin`](./README_orgin.md)。

## result
视频生成效果示例：

![infer result](./assets/一名宇航员在月球上.mp4)


### 精度
`无`

## 应用场景
### 算法类别
`视频生成`
### 热点应用行业
`影视,电商,教育,广媒`
## 预训练权重
huggingface权重下载地址为：

- [stepfun-ai/stepvideo-t2v](https://huggingface.co/stepfun-ai/stepvideo-t2v)

`注：建议加镜像源下载：export HF_ENDPOINT=https://hf-mirror.com`
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/Step-Video-T2V_pytorch.git
## 参考资料
- https://github.com/stepfun-ai/Step-Video-T2V

