from diffusers import AutoPipelineForText2Image
import torch
import time

pipeline = AutoPipelineForText2Image.from_pretrained(
	"stable-diffusion-v1-5", torch_dtype=torch.float16, variant="fp16"
).to("cuda")

generator = torch.Generator("cuda").manual_seed(31)
for i in range(2):
    start = time.time()
    image = pipeline("Astronaut in a jungle, cold color palette, muted colors, detailed, 8k", generator=generator).images[0]
    image.save(f"astronaut_rides_horse{i}.png")
    print(f"time:{time.time()-start}")
