# Stable Diffusion

## 论文
`High-Resolution Image Synthesis with Latent Diffusion Models`
- https://arxiv.org/abs/2112.10752

## 模型结构
通过串联或更通用的交叉注意机制来调节LDM

![img](./doc/arch.png)
## 算法原理
通过将图像形成过程分解为去噪自动编码器的顺序应用，扩散模型（DM）在图像数据和其他数据上实现了最先进的合成结果。为了在有限的计算资源上进行DM训练，同时保持其质量和灵活性，我们将其应用于强大的预训练自动编码器的潜在空间。在这种表示上训练扩散模型首次能够在降低复杂性和空间下采样之间达到接近最佳的点，提高了视觉逼真度。通过在模型架构中引入跨注意力层，将扩散模型变成了强大而灵活的生成器，用于文本或边界框等一般条件输入，高分辨率合成以卷积方式成为可能。我们的潜在扩散模型（LDM）在各种任务上实现了极具竞争力的性能，包括无条件图像生成、修复和超分辨率，同时与基于像素的DM相比，显著降低了计算要求。

![img](./doc/algo.png)

## 环境配置

### Docker（方法一）：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker run --rm --shm-size 10g --network=host --name=stablediffussion --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v path_to_stablediffussion:/home/sd -v /opt/hyhal:/opt/hyhal:ro -it image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10 bash
```

### Dockerfile（方法二）：
```
cd stablediffussion/docker
docker build --no-cache -t stablediffussion:test .
docker run --rm --shm-size 10g --network=host --name=stablediffussion --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v path_to_stablediffussion:/home/sd -v /opt/hyhal:/opt/hyhal:ro -it image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10 bash
```

### Conda(方式三)
1. 创建conda虚拟环境：
```
conda create -n sd1.5 python=3.10
```

2. 关于本项目DCU显卡所需的工具包、深度学习库等均可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
- [DTK 24.04](https://cancon.hpccube.com:65024/1/main/DTK-24.04.1)
- [Pytorch 2.1.0](https://cancon.hpccube.com:65024/4/main/pytorch/DAS1.1)

    Tips：以上dtk驱动、python等工具版本需要严格一一对应。


### 下载Stable Diffusion模型

模型快速下载中心：[AIModels](http://113.200.138.88:18080/aimodels), 本项目模型链接：[stable-diffusion-v1-5](http://113.200.138.88:18080/aimodels/stable-diffusion-v1-5)


## 数据集
无

## 推理

### 安装diffusers ：
pip install diffusers -i https://pypi.tuna.tsinghua.edu.cn/simple

### 行Diffusers示例：
python Diffusers.py

## result
![img](./doc/result.png)

## 精度
无

## 应用场景
### 算法类别
`以文生图`

### 热点应用行业
`绘画,动漫`

## 源码仓库及问题反馈
http://developer.hpccube.com/codes/modelzoo/stablediffussion.git

## 参考
https://github.com/CompVis/stable-diffusion
