# Stable Diffusion Version 2

## 论文
`DENOISING DIFFUSION IMPLICIT MODELS`
- https://arxiv.org/pdf/2010.02502

## 模型结构
通过串联或更通用的交叉注意机制来调节LDM

![img](./doc/arch.png)
## 算法原理
通过将图像形成过程分解为去噪自动编码器的顺序应用，扩散模型（DM）在图像数据和其他数据上实现了最先进的合成结果。为了在有限的计算资源上进行DM训练，同时保持其质量和灵活性，我们将其应用于强大的预训练自动编码器的潜在空间。在这种表示上训练扩散模型首次能够在降低复杂性和空间下采样之间达到接近最佳的点，提高了视觉逼真度。通过在模型架构中引入跨注意力层，将扩散模型变成了强大而灵活的生成器，用于文本或边界框等一般条件输入，高分辨率合成以卷积方式成为可能。我们的潜在扩散模型（LDM）在各种任务上实现了极具竞争力的性能，包括无条件图像生成、修复和超分辨率，同时与基于像素的DM相比，显著降低了计算要求。

![img](./doc/algo.png)

## 环境配置

### Docker（方法一）：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:stablediffusion_v2-1
docker run --rm --shm-size 10g --network=host --name=stablediffussion_v2-1 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -it image.sourcefind.cn:5000/dcu/admin/base/custom:stablediffusion_v2-1 bash
```
### Dockerfile（方法二）：
```
docker build --no-cache -t stablediffussion:test .
docker run --rm --shm-size 10g --network=host --name=stablediffussion_v2-1 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -it stablediffussion:test bash
```
### 下载Stable Diffusion v2.1模型
```
cd /stablediffusion-main
## 下载 SD v2.1 model
git lfs install
git clone https://huggingface.co/stabilityai/stable-diffusion-2-1-base
```
### 下载 dtk工具
```
cd /opt/
## 下载 dtk
https://cancon.hpccube.com:65024/directlink/1/DTK-24.04/CentOS7.6/DTK-24.04-CentOS7.6-x86_64.tar.gz
解压链接
tar -zxvf DTK-24.04-CentOS7.6-x86_64.tar.gz
ln -s DTK-24.04 dtk
```

## 数据集
无

## 推理

### 1、运行txt2img.py示例：
运行：
```
cd /stablediffusion-main
python scripts/txt2img.py --device cuda --prompt "a photograph of an astronaut riding a horse" --ckpt ./stable-diffusion-2-1-base/v2-1_512-ema-pruned.ckpt --config configs/stable-diffusion/v2-inference.yaml --n_iter 1 --n_samples 1
```
### 2、使用diffusers库测试：
```
python test_diffusers.py
```
## result
![img](./doc/result.png)

## 精度
无

## 应用场景
### 算法类别
`以文生图`

### 热点应用行业
`绘画,动漫`

## 源码仓库及问题反馈
http://developer.hpccube.com/codes/modelzoo/stablediffusion_v2.1_pytorch.git

## 参考
https://github.com/Stability-AI/stablediffusion
