# Stable Diffusion Version 2

## 论文

https://arxiv.org/pdf/2010.02502

## 模型结构
文生图任务是指将一段文本输入到SD模型中，经过一定的迭代次数，SD模型输出一张符合输入文本描述的图片。

<img src=./sd_model.png style="zoom:100%;" align=middle>

## 算法原理

使用CLIP Text Encode模型将输入的人类文本信息进行编码，生成与文本信息对应的Text Embeddings特征矩阵；
输入文本信息，再用random函数生成一个高斯噪声矩阵 作为Latent Feature(隐空间特征)的“替代” 输入到SD模型的 “图像优化模块” 中；
首先图像优化模块是由U-Net网络和Schedule算法 组成，将图像优化模块进行优化迭代后的Latent Feature输入到 图像解码器 （VAE Decoder） 中，将Latent Feature重建成像素级图。

<img src=./text_encoder.png style="zoom:100%;" align=middle>

<img src=./unet.png style="zoom:100%;" align=middle>

<img src=./vae.png style="zoom:100%;" align=middle>

## 环境配置

### Docker（方法一）

拉取镜像：

```shell
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:stablediffusion-migraphx-ubuntu20.04-dtk24.04.3-py310
```

创建并启动容器：

```shell
docker run --shm-size 16g --network=host --name=sd2.1_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/sd2.1_migraphx:/home/sd2.1_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```shell
cd ./docker
docker build --no-cache -t sd2.1_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=sd2.1_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/sd2.1_migraphx:/home/sd2.1_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

无

## 推理

**模型下载**
[stabilityai/stable-diffusion-2-1-base](https://huggingface.co/stabilityai/stable-diffusion-2-1-base)
[stabilityai/stable-diffusion-3.5-large](https://huggingface.co/stabilityai/stable-diffusion-3.5-large)

下面运行示例命令中的onnx-model-path参数就设置为该下载后onnx模型目录。

**设置环境变量**
```shell
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```
**安装依赖**
```shell
# 进入python示例目录
cd <path_to_sd2.1_migraphx>

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```
### 运行示例

stablediffusion_v2.1模型的推理示例程序是Diffusion_test_offload_false.py，使用如下命令运行该推理示例：

```shell
python Diffusion_test_offload_false.py --prompt "a photograph of an astronaut riding a horse" --seed 13 --output astro_horse.jpg --steps 50 --fp16 all --onnx-model-path stablediffusion_v2.1_migraphx
```

## result

推理结果：

python程序运行结束后，会在当前目录保存推理生成的图像。

<img src="./astro_horse.jpg" alt="Result" style="zoom: 50%;" />


### 精度

无

## 应用场景

### 算法类别

`以文生图`

### 热点应用行业

`绘画`,`动漫`,`媒体`

## 源码仓库及问题反馈

https://developer.sourcefind.cn/codes/modelzoo/stablediffusion_v2.1_migraphx

## 参考资料

https://github.com/Stability-AI/stablediffusion
