export MODEL_NAME="/path/to/stable-diffusion-2-1-base/"
export OUTPUT_DIR="./output/sd2.1"
export DATASET_NAME="/path/to/data/train-00000-of-00001-566cc9b19d7203f8.parquet"
#export DATASET_NAME="./pokemon-blip-captions"
#export HIP_VISIBLE_DEVICES=7
#export LD_LIBRARY_PATH=/opt/rocblas-install/lib/:$LD_LIBRARY_PATH
#export PYTORCH_HIP_ALLOC_CONF=max_split_size_mb:25314
export HIP_VISIBLE_DEVICES=4,5,6,7

torchrun --nproc_per_node=4 train_text_to_image_lora.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --dataset_name=$DATASET_NAME \
  --dataloader_num_workers=8 \
  --resolution=960 \
  --center_crop \
  --random_flip \
  --train_batch_size=8 \
  --gradient_accumulation_steps=4 \
  --max_train_steps=101 \
  --learning_rate=1e-04 \
  --max_grad_norm=1 \
  --lr_scheduler="cosine" \
  --lr_warmup_steps=0 \
  --output_dir=${OUTPUT_DIR} \
  --report_to=wandb \
  --checkpointing_steps=50000 \
  --validation_prompt="A pokemon with blue eyes." \
  --seed=1337 \
  --mixed_precision="fp16" \
  --image_column="image" \
  --caption_column="text"

