# Stable Diffusion 3 Medium
## 论文

`Scaling Rectified Flow Transformers for High-Resolution Image Synthesis`

https://arxiv.org/abs/2403.03206

## 模型结构

Stable Diffusion 3 Medium 是一种多模态扩散转换器(MMDiT)文本到图像模型，在图像质量、排版、复杂提示理解和资源效率方面具有显着改进的性能。

本项目主要针对Stable Diffusion 3 Medium在DCU平台的推理性能优化，达到DCU平台较快的生成效果。

![img](docs/mmdit.png)


## 算法原理

SD3 以序列 Embedding 的形式处理文本输入和视觉隐空间特征。位置编码是施加在隐空间特征的 2x2 patch 上的，随后被展开成 patch 的 Enbedding 序列。这一序列和文本的特征序列一起，被送入 MMDiT 的各个模块中去。两种特征序列被转化成相同特征维度，拼接在一起，然后送入一系列注意力机制模块和多层感知机 (MLP) 里。

为应对两种模态间的差异，MMDiT 模块使用两组不同的权重去转换文本和图像序列的特征维度。两个序列之后会在注意力操作之前被合并在一起。这种设计使得两种表征能在自己的特征空间里工作，同时也使得它们之间可以通过注意力机制从对方的特征中提取有用的信息。这种文本和图像间双向的信息流动有别于以前的文生图模型，后者的文本信息是通过 cross-attention 送入模型的，且不同层输入的文本特征均是文本编码器的输出，不随深度的变化而改变。

![img](docs/algorithm.png)

## 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:stablediffusion_v2-1_dtk24.04_xformers0.0.25_py310
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name sd3 --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
```
镜像版本依赖：
* DTK驱动：dtk24.04
* Pytorch: 2.1.0
* python: python3.10

## 数据集
无

## 推理
### 安装diffuser和依赖

```
git clone http://developer.sourcefind.cn/codes/modelzoo/stable-diffusion-3-medium_diffusers.git
cd stable-diffusion-3-medium_diffusers
git submodule init && git submodule update

1. 卸载旧torch和diffusers
pip uninstall torch diffusers
2. 安装新版本
cd diffusers
python3 setup.py install
cd .. && ./env.sh

```

### 模型下载
[stable-diffusion-3-medium-diffusers](https://huggingface.co/stabilityai/stable-diffusion-3-medium)

### 运行 stable-diffusion-3-medium

```
python SD3-medium.py

使用xformers计算attention：
export USE_XFORMERS=1
python SD3-medium.py
```

## result
![img](./docs/result.png)

### 精度
无

## 应用场景
### 算法类别
`以文生图`

### 热点应用行业
`绘画,动漫,媒体`

## 源码仓库及问题反馈
http://developer.sourcefind.cn/codes/modelzoo/stable-diffusion-3-medium_diffusers.git

## 参考资料
https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers

