# 下载模型
 
 ```
https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers
 ```




# 建立环境

```
conda create -n   sd3  python=3.10
pip  install https://cancon.hpccube.com:65024/directlink/4/pytorch/DAS1.1.1/torch-2.1.0+gitf643949.abi1.dtk2404-cp310-cp310-manylinux_2_31_x86_64.whl
pip  install https://cancon.hpccube.com:65024/directlink/4/vision/DAS1.1/torchvision-0.16.0+das1.1.git7d45932.abi1.dtk2404.torch2.1-cp310-cp310-manylinux_2_31_x86_64.whl
pip  install https://cancon.hpccube.com:65024/directlink/4/xformers/DAS1.1/xformers-0.0.25+das1.1.git8ef8bc1.abi1.dtk2404.torch2.1.0-cp310-cp310-manylinux_2_31_x86_64.whl  -i https://pypi.tuna.tsinghua.edu.cn/simple
git clone http://developer.hpccube.com/codes/modelzoo/stable-diffusion-3-medium_diffusers.git
cd stable-diffusion-3-medium_diffusers
git submodule init && git submodule update
cd diffusers
python3 setup.py install
cd .. 
pip install https://cancon.hpccube.com:65024/directlink/4/triton/DAS1.1/triton-2.1.0+das1.1.git4bf1007a.abi1.dtk2404.torch2.1.0-cp310-cp310-manylinux_2_31_x86_64.whl   -i https://pypi.tuna.tsinghua.edu.cn/simple
 pip install https://cancon.hpccube.com:65024/directlink/4/flash_attn/DAS1.1/flash_attn-2.0.4+das1.1gitc7a8c18.abi1.dtk2404.torch2.1-cp310-cp310-manylinux_2_31_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
 pip install transformers protobuf  accelerate peft  sentencepiece  tokenizer  -i https://pypi.tuna.tsinghua.edu.cn/simple
```


# 运行

test_stable_difusers.py

```
import torch
from multiprocessing import get_context
from diffusers import StableDiffusion3Pipeline
import time


def generate_images_on_gpu(gpu_id, start_index, end_index):
    # 指定使用的GPU
    device = torch.device(f'cuda:{gpu_id}')
    
    # 加载模型到指定的GPU
    pipe = StableDiffusion3Pipeline.from_pretrained(
        "model/stable-diffusion-3-medium-diffusers",
        torch_dtype=torch.float16,
        use_auth_token=True
    )
    pipe = pipe.to(device)

    # 生成图片
    for i in range(start_index, end_index):
        # 为每张图片指定唯一的文件名
        filename = f"sd-100-imgs/game_of_thrones_{i}.png"

        # 生成图片
        t0 = time.time()
        image = pipe(
            "game of thrones",
            negative_prompt="",
            num_inference_steps=28,
            guidance_scale=7.0,
        ).images[0]

        # 保存图片
        image.save(filename)
        print(f"Image {filename} saved on GPU {gpu_id}. Elapsed: {time.time()-t0} s")

def main():
    # 确定GPU的数量
    num_gpus = 1
    print(f"Found {num_gpus} GPUs.")
    
    # 确保GPU数量至少为1
    if num_gpus < 1:
        raise Exception("No GPUs found. Please ensure you have at least one GPU available.")
    
    # 定义每个GPU生成的图片数量
    images_per_gpu = 100 // num_gpus
    
    # 使用spawn启动方法创建上下文
    start = time.time()
    with get_context("spawn").Pool(processes=num_gpus) as pool:
        # 创建进程
        results = [pool.apply_async(generate_images_on_gpu, args=(gpu_id, gpu_id * images_per_gpu, (gpu_id + 1) * images_per_gpu if gpu_id != num_gpus - 1 else 100)) for gpu_id in range(num_gpus)]
        
        # 等待所有进程完成
        for result in results:
            result.get()
    print(f"Elapsed {time.time()-start} s")


if __name__ == "__main__":
    main()

```

更改stable-diffusion-3-medium-diffusers模型所在路径，在当前文件件建立新的文件夹sd-100-imgs,执行以上代码

```
mkdir sd-100-imgs
python test_stable_difusers.py
```


