# SSD
## 论文
SSD: Single Shot MultiBox Detector

- https://link.springer.com/chapter/10.1007/978-3-319-46448-0_2
## 模型结构
SSD模型结构包括一个基础卷积网络（如VGG16或ResNet）作为特征提取器，后接多个卷积层，这些层负责生成不同尺度的特征图，以便于检测不同大小的物体。

## 算法原理
SSD通过在每个特征图上直接预测边界框和类别概率，使用多种尺寸的默认框来覆盖图像中的目标，在一个前向传播中完成目标检测，显著提高了检测速度。


## 环境配置
### Docker
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it  --shm-size 80g --network=host --name=SSD --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310 bin/bash
```
安装docker中没有的依赖：
```
pip install -r requirements.txt
```
## 数据集
在本测试中可以使用Pascal VOC0712 (2007 + 2012)数据集。

- 数据集下载地址:
  - [SCNet AIDatasets](http://113.200.138.88:18080/aidatasets/voc0712/-/tree/Maintainers?ref_type=heads)

数据集的目录结构如下（进入VOCdevkit0712/voc2007_2012/VOCdevkit即可）：

```
VOC_ROOT
|__ VOC20xx
    |_ JPEGImages
    |_ Annotations
    |_ ImageSets
    |_ SegmentationClass
|__ VOC20xx
    |_ JPEGImages
    |_ Annotations
    |_ ImageSets
    |_ SegmentationClass
|__ ...
```
在`SSD/ssd/config/path_catlog.py`中第5行`DATA_DIR = '{数据集所在文件夹}/VOCdevkit0712/voc2007_2012/VOCdevkit'`修改数据集地址。

## 训练

### 单卡训练
```bash
python train.py --config-file configs/vgg_ssd300_voc0712.yaml
```

### 多卡训练

```
python -m torch.distributed.launch --nproc_per_node=4 train.py --config-file configs/vgg_ssd300_voc0712.yaml SOLVER.WARMUP_FACTOR 0.03333 SOLVER.WARMUP_ITERS 1000
```
## 推理

### 单卡推理

```bash
python test.py --config-file configs/vgg_ssd300_voc0712.yaml
```
### 多卡推理

```
python -m torch.distributed.launch --nproc_per_node=4 test.py --config-file configs/vgg_ssd300_voc0712.yaml
```
##结果
[result](result.jpg)

## 应用场景
### 算法类别
目标检测
### 热点应用行业
金融,交通,教育
## 源码仓库及问题反馈
https://developer.sourcefind.cn/codes/modelzoo/ssd

## 参考资料
https://github.com/lufficc/SSD
