# SSD
## 论文
SSD: Single Shot MultiBox Detector

- https://link.springer.com/chapter/10.1007/978-3-319-46448-0_2
## 模型结构
SSD模型结构包括一个基础卷积网络（如VGG16或ResNet）作为特征提取器，后接多个卷积层，这些层负责生成不同尺度的特征图，以便于检测不同大小的物体。

## 算法原理
SSD通过在每个特征图上直接预测边界框和类别概率，使用多种尺寸的默认框来覆盖图像中的目标，在一个前向传播中完成目标检测，显著提高了检测速度。


## 环境配置
### Docker
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it  --shm-size 80g --network=host --name=SSD --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310 bin/bash
```
其它非深度学习库参照requirements.txt安装：
```
pip install -r requirements.txt
pip install pycocotools
```
## 数据集
#### 小数据集

coco2017_50数据集

解压后使用训练/推理命令默认使用该数据集。

#### 标准数据集

Pascal VOC数据集

下载地址：[SCNet AIDatasets](http://113.200.138.88:18080/aidatasets/voc0712/-/tree/Maintainers?ref_type=heads)

SCNet中提供的数据集包含voc2007和voc2012，其文件目录如下：

```
VOCdevkit0712/voc2007_2012/VOCdevkit
|__ VOC2007
    |_ JPEGImages
    |_ Annotations
    |_ ImageSets
    |_ SegmentationClass
|__ VOC2012
    |_ JPEGImages
    |_ Annotations
    |_ ImageSets
    |_ SegmentationClass
```
在`SSD/ssd/config/path_catlog.py`中第5行`DATA_DIR = '{path_to_dataset}'`指定数据集。

使用VOC2007：`DATA_DIR = 'VOCdevkit0712/voc2007_2012/VOCdevkit/VOC2007/'`

使用VOC2012：`DATA_DIR = 'VOCdevkit0712/voc2007_2012/VOCdevkit/VOC2012/'`

使用VOC0712：`DATA_DIR = 'VOCdevkit0712/voc2007_2012/VOCdevkit/'`

注意：如果使用标准数据集，将命令中`--config-file`改成`configs/vgg_ssd300_voc0712`'

## 训练

### 单卡训练
```bash
python train.py --config-file configs/vgg_ssd300_coco2017_50_trainval.yaml
```

### 多卡训练

```bash
python -m torch.distributed.launch --nproc_per_node=4 train.py --config-file configs/vgg_ssd300_coco2017_50_trainval.yaml SOLVER.WARMUP_FACTOR 0.03333 SOLVER.WARMUP_ITERS 1000
```
## 推理

### 单卡推理

```bash
python test.py --config-file configs/vgg_ssd300_coco2017_50_trainval.yaml
```
### 多卡推理

```bash
python -m torch.distributed.launch --nproc_per_node=4 test.py --config-file configs/vgg_ssd300_coco2017_50_trainval.yaml
```

## result

### 输出实例

![result](result.jpg)

### 精度

|        | VOC2007 test（mAP） | coco test-dev2015（mAP） |
| :----: | :----------: | :---------------: |
| SSD300 |     77.2     |       25.1        |
| SSD512 |     79.8     |       28.8        |

## 应用场景

### 算法类别
目标检测
### 热点应用行业
金融,交通,教育
## 源码仓库及问题反馈
https://developer.sourcefind.cn/codes/modelzoo/ssd

## 参考资料
https://github.com/lufficc/SSD
